/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.pythonCommandQueue;

import com.intellij.core.CoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.actions.ContentChooser;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pythonCommandQueue.PythonCommandQueuePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QueueElementPanel {
    private final QueueElementButton myCancelButton;
    private final JBLabel myText;
    private final Item myItem;
    private final JPanel myRootPanel;
    private final ConsoleCommunication.ConsoleCodeFragment myCodeFragment;
    private final JPanel buttonPanel;
    private static final int TEXT_MAX_LENGTH = 25;
    private static final int LABEL_FONT_SIZE = 13;
    private static final int ROOT_PANEL_MINIMUM_SIZE_WIDTH = 200;
    private static final int ROOT_PANEL_MINIMUM_SIZE_HEIGHT = 20;
    private static final int ROOT_PANEL_PREFERRED_SIZE_WIDTH = -1;
    private static final int ROOT_PANEL_PREFERRED_SIZE_HEIGHT = 20;
    private volatile boolean isCanceled;

    public QueueElementPanel(@NotNull ConsoleCommunication.ConsoleCodeFragment codeFragment, @Nullable Icon icon) {
        if (codeFragment == null) {
            QueueElementPanel.$$$reportNull$$$0(0);
        }
        this.myCancelButton = this.createCancelButton();
        this.myText = new JBLabel();
        this.myRootPanel = new JPanel();
        this.myCodeFragment = codeFragment;
        this.myText.setFont((Font)JBUI.Fonts.label((float)13.0f));
        this.myItem = new Item(codeFragment.getText().trim());
        this.myText.setText(this.myItem.getShortText(25));
        if (icon != null) {
            this.myText.setIcon(icon);
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(QueueElementPanel.createButtonPanel((JComponent)this.myCancelButton.button));
        this.buttonPanel.setOpaque(true);
        this.buttonPanel.setBackground(JBColor.background());
        this.buttonPanel.setForeground(JBColor.foreground());
        this.myRootPanel.setLayout(new BorderLayout());
        this.myRootPanel.setMinimumSize(new Dimension(200, 20));
        this.myRootPanel.setPreferredSize(new Dimension(-1, 20));
        this.myRootPanel.add((Component)this.myText, "West");
        this.myRootPanel.add((Component)this.buttonPanel, "East");
        this.myRootPanel.setBackground(JBColor.background());
        this.myRootPanel.setFocusable(true);
        this.myRootPanel.requestFocusInWindow();
        this.myRootPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QueueElementPanel.this.getCommandPanelParent().commandSelected(QueueElementPanel.this);
            }
        });
    }

    @NotNull
    private static JPanel createButtonPanel(@NotNull JComponent component2) {
        if (component2 == null) {
            QueueElementPanel.$$$reportNull$$$0(1);
        }
        NonOpaquePanel iconsPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        GridBag gb = new GridBag().setDefaultFill(1);
        iconsPanel.add((Component)component2, gb.next());
        NonOpaquePanel nonOpaquePanel = iconsPanel;
        if (nonOpaquePanel == null) {
            QueueElementPanel.$$$reportNull$$$0(2);
        }
        return nonOpaquePanel;
    }

    @NotNull
    private QueueElementButton createCancelButton() {
        InplaceButton cancelButton = new InplaceButton(new IconButton(CoreBundle.message((String)"button.cancel", (Object[])new Object[0]), AllIcons.Process.StopHovered, AllIcons.Process.StopHovered), __ -> this.cancelRequest());
        cancelButton.setVisible(true);
        cancelButton.setFillBg(true);
        return new QueueElementButton(cancelButton, () -> cancelButton.setPainting(!this.isCanceled));
    }

    @Nullable
    public String getText() {
        return this.myItem.getLongText();
    }

    private void cancelRequest() {
        if (this.myCancelButton.button.isActive()) {
            this.isCanceled = true;
            this.getCommandPanelParent().removeCommandByButton(this.myCodeFragment);
        }
    }

    private PythonCommandQueuePanel getCommandPanelParent() {
        Container parent = this.myRootPanel;
        while (!(parent instanceof PythonCommandQueuePanel)) {
            parent = parent.getParent();
        }
        return (PythonCommandQueuePanel)parent;
    }

    public void setIcon(@NotNull Icon icon) {
        if (icon == null) {
            QueueElementPanel.$$$reportNull$$$0(3);
        }
        this.myText.setIcon(icon);
    }

    public void unsetCancelButton() {
        this.buttonPanel.setEnabled(false);
        this.buttonPanel.setVisible(false);
        this.buttonPanel.setFocusable(false);
    }

    @NotNull
    public JComponent getQueuePanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            QueueElementPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    public void setTextColor() {
        this.myText.setForeground(NamedColorUtil.getListSelectionForeground((boolean)false));
    }

    public void setButtonColor() {
        this.buttonPanel.setBackground((Color)JBColor.lazy(UIUtil::getListBackground));
    }

    public void selectPanel() {
        this.myRootPanel.setBackground(UIUtil.getListSelectionBackground((boolean)true));
        this.myText.setForeground(NamedColorUtil.getListSelectionForeground((boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/pythonCommandQueue/QueueElementPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/pythonCommandQueue/QueueElementPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueuePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createButtonPanel";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    static class QueueElementButton {
        @NotNull
        final InplaceButton button;
        @NotNull
        final Runnable updateAction;

        QueueElementButton(@NotNull InplaceButton button, @NotNull Runnable updateAction) {
            if (button == null) {
                QueueElementButton.$$$reportNull$$$0(0);
            }
            if (updateAction == null) {
                QueueElementButton.$$$reportNull$$$0(1);
            }
            this.button = button;
            this.updateAction = updateAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "button";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "updateAction";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/console/pythonCommandQueue/QueueElementPanel$QueueElementButton";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Item
    extends ContentChooser.Item {
        Item(String longText) {
            super(0, longText);
        }

        public String getLongText() {
            return this.longText;
        }
    }
}

