/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;

public final class XmlElementChangeUtil {
    private XmlElementChangeUtil() {
    }

    static void doNameReplacement(PsiNamedElement xmlElementDecl, XmlElement nameElement, String name) throws IncorrectOperationException {
        if (xmlElementDecl.isWritable() && XmlElementChangeUtil.isInProjectContent(xmlElementDecl.getProject(), xmlElementDecl.getContainingFile().getVirtualFile()) && nameElement != null) {
            nameElement.replace(SourceTreeToPsiMap.treeElementToPsi((ASTNode)Factory.createSingleLeafElement((IElementType)XmlTokenType.XML_NAME, (CharSequence)name, null, (PsiManager)xmlElementDecl.getManager())));
        }
    }

    static boolean isInProjectContent(Project project, VirtualFile vfile) {
        return vfile == null || ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(vfile) != null;
    }
}

