/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;

public class RecordReaper
extends TimerTask {
    static Logger logger = Logger.getLogger(RecordReaper.class.getName());
    private final JmDNSImpl jmDNSImpl;

    public RecordReaper(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JmDNSImpl jmDNSImpl = this.jmDNSImpl;
        synchronized (jmDNSImpl) {
            if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                return;
            }
            logger.finest("run() JmDNS reaping cache");
            ArrayList<DNSEntry> list = new ArrayList<DNSEntry>();
            DNSCache dNSCache = this.jmDNSImpl.getCache();
            synchronized (dNSCache) {
                Iterator i = this.jmDNSImpl.getCache().iterator();
                while (i.hasNext()) {
                    for (DNSCache.CacheNode n = (DNSCache.CacheNode)i.next(); n != null; n = n.next()) {
                        list.add(n.getValue());
                    }
                }
            }
            long now = System.currentTimeMillis();
            for (DNSRecord dNSRecord : list) {
                if (!dNSRecord.isExpired(now)) continue;
                this.jmDNSImpl.updateRecord(now, dNSRecord);
                this.jmDNSImpl.getCache().remove(dNSRecord);
            }
        }
    }
}

