/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportProductionPanel
extends ReportPanel {
    private static final int NUMBER_OF_GOODS = 4;
    private final List<GoodsType> goodsTypes = CollectionUtils.transform(this.getSpecification().getGoodsTypeList(), gt -> !gt.isFarmed());
    private final List<JComboBox<String>> boxes;

    public ReportProductionPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportProductionAction");
        List<String> goodsNames = CollectionUtils.transform(this.goodsTypes, CollectionUtils.alwaysTrue(), gt -> Messages.getName(gt));
        goodsNames.add(0, Messages.message("nothing"));
        String[] model = goodsNames.toArray(new String[0]);
        this.boxes = new ArrayList<JComboBox<String>>(4);
        for (int index = 0; index < 4; ++index) {
            JComboBox<String> newBox = new JComboBox<String>(model);
            newBox.setSelectedIndex(0);
            this.boxes.add(newBox);
        }
        this.reportPanel.setLayout(new MigLayout("gap 0 0", "[fill]", "[fill]"));
        this.update();
    }

    private void update() {
        this.reportPanel.removeAll();
        JLabel selectLabel = Utility.localizedLabel("report.production.selectGoods");
        this.reportPanel.add(selectLabel);
        FreeColButton selectButton = Utility.localizedButton("report.production.update");
        selectButton.addActionListener(ae -> this.update());
        this.reportPanel.add((Component)selectButton, "wrap");
        ArrayList<GoodsType> selectedTypes = new ArrayList<GoodsType>();
        for (int index = 0; index < 4; ++index) {
            JComboBox<String> box = this.boxes.get(index);
            this.reportPanel.add(box);
            int selectedIndex = box.getSelectedIndex();
            if (selectedIndex <= 0) continue;
            selectedTypes.add(this.goodsTypes.get(selectedIndex - 1));
        }
        if (!selectedTypes.isEmpty()) {
            Specification spec = this.getSpecification();
            FreeColClient fcc = this.getFreeColClient();
            Function<GoodsType, Set> mapper = gt -> CollectionUtils.transform(spec.getBuildingTypeList(), bt -> gt == bt.getProducedGoodsType() || bt.hasModifier(gt.getId()), BuildingType::getFirstLevel, Collectors.toSet());
            List<Set> basicBuildingTypes = CollectionUtils.transform(selectedTypes, CollectionUtils.alwaysTrue(), mapper);
            JLabel newLabel = Utility.localizedLabel("Colony");
            newLabel.setBorder(Utility.getTopLeftCellBorder());
            this.reportPanel.add((Component)newLabel, "newline 20");
            for (int index = 0; index < selectedTypes.size(); ++index) {
                newLabel = Utility.localizedLabel((FreeColSpecObjectType)selectedTypes.get(index));
                newLabel.setBorder(Utility.getTopCellBorder());
                this.reportPanel.add(newLabel);
                for (BuildingType bt : basicBuildingTypes.get(index)) {
                    newLabel = Utility.localizedLabel(bt);
                    newLabel.setBorder(Utility.getTopCellBorder());
                    this.reportPanel.add(newLabel);
                }
            }
            Player player = this.getMyPlayer();
            for (Colony colony : player.getColonyList()) {
                JButton colonyButton = Utility.getLinkButton(colony.getName(), null, colony.getId());
                colonyButton.setBorder(Utility.getLeftCellBorder());
                colonyButton.addActionListener(this);
                this.reportPanel.add((Component)colonyButton, "newline");
                for (int index = 0; index < selectedTypes.size(); ++index) {
                    GoodsType goodsType = (GoodsType)selectedTypes.get(index);
                    int newValue = colony.getNetProductionOf(goodsType);
                    Goods goods = new Goods(colony.getGame(), colony, goodsType, newValue);
                    GoodsLabel goodsLabel = new GoodsLabel(fcc, goods);
                    goodsLabel.setHorizontalAlignment(10);
                    goodsLabel.setBorder(Utility.getCellBorder());
                    this.reportPanel.add(goodsLabel);
                    for (BuildingType bt : basicBuildingTypes.get(index)) {
                        Building building = colony.getBuilding(bt);
                        if (building == null) {
                            newLabel = new JLabel();
                            newLabel.setBorder(Utility.getCellBorder());
                            this.reportPanel.add(newLabel);
                            continue;
                        }
                        BuildingPanel buildingPanel = new BuildingPanel(fcc, building);
                        buildingPanel.setBorder(Utility.getCellBorder());
                        buildingPanel.initialize();
                        this.reportPanel.add(buildingPanel);
                    }
                }
            }
        }
        this.revalidate();
        this.repaint();
    }
}

