/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.man;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.man.AeshFileDisplayer;
import org.aesh.command.man.FileParser;
import org.aesh.command.man.TerminalPage;
import org.aesh.command.man.parser.ManFileParser;
import org.aesh.command.option.Arguments;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.ManProvider;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

@CommandDefinition(name="man", description="manuals")
public class Man
extends AeshFileDisplayer {
    @Arguments(completer=ManCompleter.class)
    private final List<String> manPages;
    private final ManFileParser fileParser;
    private CommandRegistry<? extends CommandInvocation> registry;
    private final ManProvider manProvider;

    public Man(ManProvider manProvider) {
        this.manProvider = manProvider;
        this.manPages = new ArrayList<String>();
        this.fileParser = new ManFileParser();
    }

    public void setRegistry(CommandRegistry<? extends CommandInvocation> registry) {
        this.registry = registry;
    }

    @Override
    public FileParser getFileParser() {
        return this.fileParser;
    }

    @Override
    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.INVERT_BACKGROUND + "Pattern not found (press RETURN)" + "\u001b[0;39m");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH || this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(ANSI.INVERT_BACKGROUND);
            this.writeToConsole("Manual page " + this.fileParser.getName() + " line " + this.getTopVisibleRow() + " (press h for help or q to quit)" + "\u001b[0;39m");
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.manPages == null || this.manPages.size() == 0) {
            commandInvocation.getShell().write("What manual page do you want?" + Config.getLineSeparator());
            return CommandResult.SUCCESS;
        }
        if (this.manPages.size() <= 0) {
            commandInvocation.getShell().write("No manual entry for " + this.manPages.get(0) + Config.getLineSeparator());
            return CommandResult.SUCCESS;
        }
        if (this.manProvider == null) {
            commandInvocation.getShell().write("No manual provider defined");
            return CommandResult.SUCCESS;
        }
        InputStream inputStream = this.manProvider.getManualDocument(this.manPages.get(0));
        if (inputStream != null) {
            this.setCommandInvocation(commandInvocation);
            try {
                this.fileParser.setInput(inputStream);
                this.afterAttach();
            }
            catch (IOException ex) {
                throw new CommandException(ex);
            }
        }
        return CommandResult.SUCCESS;
    }

    public class ManCompleter
    implements OptionCompleter {
        public void complete(CompleterInvocation completerData) {
            ArrayList<String> completeValues = new ArrayList<String>();
            if (Man.this.registry != null) {
                for (String command : Man.this.registry.getAllCommandNames()) {
                    if (!command.startsWith(completerData.getGivenCompleteValue())) continue;
                    completeValues.add(command);
                }
                completerData.setCompleterValues(completeValues);
            }
        }
    }
}

