/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public abstract class MavenUniverseBase
implements Universe<MavenProducer> {
    protected final MavenRepoManager repo;
    protected final MavenArtifact artifact;

    protected MavenUniverseBase(MavenRepoManager repoManager, MavenArtifact artifact) {
        this.repo = repoManager;
        this.artifact = artifact;
    }

    @Override
    public String getFactoryId() {
        return "maven";
    }

    @Override
    public String getLocation() {
        return this.artifact.getCoordsAsString();
    }

    public MavenRepoManager getRepo() {
        return this.repo;
    }

    public MavenArtifact getArtifact() {
        return this.artifact;
    }

    protected static Path getProducerLocations(FileSystem zipfs) {
        return zipfs.getPath("galleon", "universe", "producer", "locations");
    }

    protected static Path getProducerLocations(Path root) {
        return root.resolve("galleon").resolve("universe").resolve("producer").resolve("locations");
    }

    protected static Path getProducerXml(FileSystem zipfs, String producerName) {
        return MavenUniverseBase.getProducerXml(MavenUniverseBase.getProducerLocations(zipfs), producerName);
    }

    protected static Path getProducerXml(Path producersDir, String producerName) {
        return producersDir.resolve(producerName).resolve("maven-producer.xml");
    }
}

