/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.deployment.internal;

import javax.annotation.Nullable;
import org.gradle.deployment.internal.ContinuousExecutionGate;
import org.gradle.deployment.internal.DeploymentHandle;
import org.gradle.deployment.internal.DeploymentInternal;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.deployment.internal.GateControllingDeployment;
import org.gradle.deployment.internal.OutOfDateTrackingDeployment;
import org.gradle.deployment.internal.SimpleBlockingDeployment;
import org.gradle.internal.concurrent.Stoppable;

class RegisteredDeployment
implements Stoppable {
    private final String id;
    private final DeploymentInternal delegate;
    private final DeploymentHandle handle;
    private final boolean restartable;

    private RegisteredDeployment(String id, boolean restartable, DeploymentHandle handle, DeploymentInternal delegate) {
        this.id = id;
        this.restartable = restartable;
        this.delegate = delegate;
        this.handle = handle;
    }

    static RegisteredDeployment create(String id, DeploymentRegistry.ChangeBehavior changeBehavior, ContinuousExecutionGate continuousExecutionGate, DeploymentHandle deploymentHandle) {
        switch (changeBehavior) {
            case NONE: {
                return new RegisteredDeployment(id, false, deploymentHandle, new OutOfDateTrackingDeployment());
            }
            case RESTART: {
                return new RegisteredDeployment(id, true, deploymentHandle, new SimpleBlockingDeployment(new OutOfDateTrackingDeployment()));
            }
            case BLOCK: {
                return new RegisteredDeployment(id, false, deploymentHandle, new GateControllingDeployment(continuousExecutionGate, new SimpleBlockingDeployment(new OutOfDateTrackingDeployment())));
            }
        }
        throw new IllegalArgumentException("Unknown changeBehavior " + (Object)((Object)changeBehavior));
    }

    public DeploymentInternal getDeployment() {
        return this.delegate;
    }

    public void outOfDate() {
        this.delegate.outOfDate();
    }

    public void upToDate(@Nullable Throwable failure) {
        this.delegate.upToDate(failure);
        this.restart();
    }

    public DeploymentHandle getHandle() {
        return this.handle;
    }

    public void stop() {
        this.handle.stop();
    }

    private void restart() {
        if (this.restartable) {
            this.handle.stop();
            this.handle.start(this.delegate);
        }
    }

    public String toString() {
        return "Deployment{id='" + this.id + '\'' + ", handle=" + this.handle + ", restartable=" + this.restartable + '}';
    }
}

