/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.execution.BuildTaskScheduler;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.commandline.CommandLineTaskParser;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.selection.BuildTaskSelector;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskNameResolvingBuildTaskScheduler
implements BuildTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskNameResolvingBuildTaskScheduler.class);
    private final CommandLineTaskParser commandLineTaskParser;
    private final BuildTaskSelector.BuildSpecificSelector taskSelector;
    private final List<BuiltInCommand> builtInCommands;

    public TaskNameResolvingBuildTaskScheduler(CommandLineTaskParser commandLineTaskParser, BuildTaskSelector.BuildSpecificSelector taskSelector, List<BuiltInCommand> builtInCommands) {
        this.commandLineTaskParser = commandLineTaskParser;
        this.taskSelector = taskSelector;
        this.builtInCommands = builtInCommands;
    }

    @Override
    public void scheduleRequestedTasks(GradleInternal gradle, @Nullable EntryTaskSelector selector, ExecutionPlan plan) {
        if (selector != null) {
            selector.applyTasksTo(new EntryTaskSelectorContext(gradle), plan);
        }
        List taskParameters = gradle.getStartParameter().getTaskRequests();
        for (TaskExecutionRequest taskParameter : taskParameters) {
            List<TaskSelection> taskSelections = this.commandLineTaskParser.parseTasks(taskParameter);
            for (TaskSelection taskSelection : taskSelections) {
                LOGGER.info("Selected primary task '{}' from project {}", (Object)taskSelection.getTaskName(), (Object)taskSelection.getProjectPath());
                plan.addEntryTasks(taskSelection.getTasks());
            }
        }
        this.validateCompatibleTasksRequested(plan);
    }

    private void validateCompatibleTasksRequested(ExecutionPlan plan) {
        List requestedTaskNames;
        if (null != plan.getContents() && (requestedTaskNames = plan.getContents().getRequestedTasks().stream().map(Task::getName).collect(Collectors.toList())).size() > 1) {
            Optional<BuiltInCommand> exclusiveTaskInvoked = this.builtInCommands.stream().filter(BuiltInCommand::isExclusive).filter(c -> c.commandLineMatches(requestedTaskNames)).findFirst();
            exclusiveTaskInvoked.ifPresent(builtInCommand -> ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)("Executing other tasks along with the '" + builtInCommand.getDisplayName() + "' task")).withAdvice("The " + builtInCommand.getDisplayName() + " task should be run by itself.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "init_must_run_alone")).nagUser());
        }
    }

    @NonNullApi
    private class EntryTaskSelectorContext
    implements EntryTaskSelector.Context {
        final GradleInternal gradle;

        public EntryTaskSelectorContext(GradleInternal gradle) {
            this.gradle = gradle;
        }

        @Override
        public TaskSelection getSelection(String taskPath) {
            return TaskNameResolvingBuildTaskScheduler.this.taskSelector.resolveTaskName(taskPath);
        }

        @Override
        public GradleInternal getGradle() {
            return this.gradle;
        }
    }
}

