/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.data.IFieldRef;
import jadx.api.plugins.input.data.IMethodHandle;
import jadx.api.plugins.input.data.IMethodProto;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.insns.InsnData;
import jadx.api.plugins.input.insns.InsnIndexType;
import jadx.api.plugins.input.insns.Opcode;
import jadx.api.plugins.input.insns.custom.ICustomPayload;
import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.code.ArrayType;
import jadx.plugins.input.java.data.code.CodeDecodeState;
import jadx.plugins.input.java.data.code.JavaInsnInfo;
import jadx.plugins.input.java.data.code.decoders.IJavaInsnDecoder;
import org.jetbrains.annotations.Nullable;

public class JavaInsnData
implements InsnData {
    private final CodeDecodeState state;
    private JavaInsnInfo insnInfo;
    private Opcode opcode;
    private boolean decoded;
    private int opcodeUnit;
    private int payloadSize;
    private int insnStart;
    private int offset;
    private int regsCount;
    private int[] argsReg = new int[16];
    private int resultReg;
    private long literal;
    private int target;
    private int index;
    @Nullable
    private ICustomPayload payload;

    public JavaInsnData(CodeDecodeState state) {
        this.state = state;
    }

    public void decode() {
        IJavaInsnDecoder decoder = this.insnInfo.getDecoder();
        if (decoder != null) {
            decoder.decode(this.state);
            this.state.decoded();
        }
        this.decoded = true;
    }

    public void skip() {
        IJavaInsnDecoder decoder = this.insnInfo.getDecoder();
        if (decoder != null) {
            decoder.skip(this.state);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFileOffset() {
        return this.insnStart;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public void setOpcode(Opcode opcode) {
        this.opcode = opcode;
    }

    public String getOpcodeMnemonic() {
        return this.insnInfo.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteCode() {
        DataReader reader = this.state.reader();
        int startOffset = reader.getOffset();
        try {
            reader.absPos(this.insnStart);
            byte[] byArray = reader.readBytes(1 + this.payloadSize);
            return byArray;
        }
        finally {
            reader.absPos(startOffset);
        }
    }

    public InsnIndexType getIndexType() {
        return this.insnInfo.getIndexType();
    }

    public int getRawOpcodeUnit() {
        return this.opcodeUnit;
    }

    public int getRegsCount() {
        return this.regsCount;
    }

    public int getReg(int argNum) {
        return this.argsReg[argNum];
    }

    public int getResultReg() {
        return this.resultReg;
    }

    public void setResultReg(int resultReg) {
        this.resultReg = resultReg;
    }

    public long getLiteral() {
        return this.literal;
    }

    public int getTarget() {
        return this.target;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    public String getIndexAsString() {
        return this.constPoolReader().getUtf8(this.index);
    }

    public String getIndexAsType() {
        if (this.insnInfo.getOpcode() == 188) {
            return ArrayType.byValue(this.index);
        }
        return this.constPoolReader().getClass(this.index);
    }

    public IFieldRef getIndexAsField() {
        return this.constPoolReader().getFieldRef(this.index);
    }

    public IMethodRef getIndexAsMethod() {
        return this.constPoolReader().getMethodRef(this.index);
    }

    public ICallSite getIndexAsCallSite() {
        return this.constPoolReader().getCallSite(this.index);
    }

    public IMethodProto getIndexAsProto(int protoIndex) {
        return null;
    }

    public IMethodHandle getIndexAsMethodHandle() {
        return null;
    }

    @Nullable
    public ICustomPayload getPayload() {
        return this.payload;
    }

    public void setInsnInfo(JavaInsnInfo insnInfo) {
        this.insnInfo = insnInfo;
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public void setDecoded(boolean decoded) {
        this.decoded = decoded;
    }

    public void setOpcodeUnit(int opcodeUnit) {
        this.opcodeUnit = opcodeUnit;
    }

    public void setPayloadSize(int payloadSize) {
        this.payloadSize = payloadSize;
    }

    public void setInsnStart(int insnStart) {
        this.insnStart = insnStart;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setArgReg(int arg, int reg) {
        this.argsReg[arg] = reg;
    }

    public void setRegsCount(int regsCount) {
        this.regsCount = regsCount;
        if (this.argsReg.length < regsCount) {
            this.argsReg = new int[regsCount];
        }
    }

    public int[] getRegsArray() {
        return this.argsReg;
    }

    public void setLiteral(long literal) {
        this.literal = literal;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setPayload(ICustomPayload payload) {
        this.payload = payload;
    }

    public ConstPoolReader constPoolReader() {
        return this.state.clsData().getConstPoolReader();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("0x%04X", this.offset));
        sb.append(": ").append(this.getOpcode());
        if (this.insnInfo == null) {
            sb.append(String.format("(0x%04X)", this.opcodeUnit));
        } else {
            int regsCount = this.getRegsCount();
            if (this.isDecoded()) {
                sb.append(' ');
                for (int i = 0; i < regsCount; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append("r").append(this.argsReg[i]);
                }
            }
        }
        return sb.toString();
    }
}

