/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.api.JadxArgs;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.RootNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class ConstStorage {
    private final boolean replaceEnabled;
    private final ValueStorage globalValues = new ValueStorage();
    private final Map<ClassNode, ValueStorage> classes = new HashMap<ClassNode, ValueStorage>();
    private Map<Integer, String> resourcesNames = new HashMap<Integer, String>();

    public ConstStorage(JadxArgs args) {
        this.replaceEnabled = args.isReplaceConsts();
    }

    public void processConstFields(ClassNode cls, List<FieldNode> staticFields) {
        if (!this.replaceEnabled || staticFields.isEmpty()) {
            return;
        }
        for (FieldNode f : staticFields) {
            Object value = ConstStorage.getFieldConstValue(f);
            if (value == null) continue;
            this.addConstField(cls, f, value, f.getAccessFlags().isPublic());
        }
    }

    @Nullable
    public static Object getFieldConstValue(FieldNode fld) {
        EncodedValue constVal;
        AccessInfo accFlags = fld.getAccessFlags();
        if (accFlags.isStatic() && accFlags.isFinal() && (constVal = (EncodedValue)fld.get(JadxAttrType.CONSTANT_VALUE)) != null) {
            return constVal.getValue();
        }
        return null;
    }

    public void removeForClass(ClassNode cls) {
        this.classes.remove(cls);
        this.globalValues.removeForCls(cls);
    }

    private void addConstField(ClassNode cls, FieldNode fld, Object value, boolean isPublic) {
        if (isPublic) {
            this.globalValues.put(value, fld);
        } else {
            this.getClsValues(cls).put(value, fld);
        }
    }

    private ValueStorage getClsValues(ClassNode cls) {
        return this.classes.computeIfAbsent(cls, c -> new ValueStorage());
    }

    @Nullable
    public FieldNode getConstField(ClassNode cls, Object value, boolean searchGlobal) {
        FieldNode rField;
        if (!this.replaceEnabled) {
            return null;
        }
        RootNode root = cls.root();
        if (value instanceof Integer && (rField = this.getResourceField((Integer)value, root)) != null) {
            return rField;
        }
        boolean foundInGlobal = this.globalValues.contains(value);
        if (foundInGlobal && !searchGlobal) {
            return null;
        }
        ClassNode current = cls;
        while (current != null) {
            FieldNode field;
            ValueStorage classValues = this.classes.get(current);
            if (classValues != null && (field = classValues.get(value)) != null) {
                if (foundInGlobal) {
                    return null;
                }
                return field;
            }
            ClassInfo parentClass = current.getClassInfo().getParentClass();
            if (parentClass == null) break;
            current = root.resolveClass(parentClass);
        }
        if (searchGlobal) {
            return this.globalValues.get(value);
        }
        return null;
    }

    @Nullable
    private FieldNode getResourceField(Integer value, RootNode root) {
        String str = this.resourcesNames.get(value);
        if (str == null) {
            return null;
        }
        ClassNode appResClass = root.getAppResClass();
        if (appResClass == null) {
            return null;
        }
        String[] parts = str.split("/", 2);
        if (parts.length != 2) {
            return null;
        }
        String typeName = parts[0];
        String fieldName = parts[1];
        for (ClassNode innerClass : appResClass.getInnerClasses()) {
            if (!innerClass.getClassInfo().getShortName().equals(typeName)) continue;
            return innerClass.searchFieldByName(fieldName);
        }
        appResClass.addWarn("Not found resource field with id: " + value + ", name: " + str.replace('/', '.'));
        return null;
    }

    @Nullable
    public FieldNode getConstFieldByLiteralArg(ClassNode cls, LiteralArg arg) {
        if (!this.replaceEnabled) {
            return null;
        }
        PrimitiveType type = arg.getType().getPrimitiveType();
        if (type == null) {
            return null;
        }
        long literal = arg.getLiteral();
        switch (type) {
            case BOOLEAN: {
                return this.getConstField(cls, literal == 1L, false);
            }
            case CHAR: {
                return this.getConstField(cls, Character.valueOf((char)literal), Math.abs(literal) > 10L);
            }
            case BYTE: {
                return this.getConstField(cls, (byte)literal, Math.abs(literal) > 10L);
            }
            case SHORT: {
                return this.getConstField(cls, (short)literal, Math.abs(literal) > 100L);
            }
            case INT: {
                return this.getConstField(cls, (int)literal, Math.abs(literal) > 100L);
            }
            case LONG: {
                return this.getConstField(cls, literal, Math.abs(literal) > 1000L);
            }
            case FLOAT: {
                float f = Float.intBitsToFloat((int)literal);
                return this.getConstField(cls, Float.valueOf(f), Float.compare(f, 0.0f) == 0);
            }
            case DOUBLE: {
                double d = Double.longBitsToDouble(literal);
                return this.getConstField(cls, d, Double.compare(d, 0.0) == 0);
            }
        }
        return null;
    }

    public void setResourcesNames(Map<Integer, String> resourcesNames) {
        this.resourcesNames = resourcesNames;
    }

    public Map<Integer, String> getResourcesNames() {
        return this.resourcesNames;
    }

    public Map<Object, FieldNode> getGlobalConstFields() {
        return this.globalValues.getValues();
    }

    public boolean isReplaceEnabled() {
        return this.replaceEnabled;
    }

    private static final class ValueStorage {
        private final Map<Object, FieldNode> values = new ConcurrentHashMap<Object, FieldNode>();
        private final Set<Object> duplicates = new HashSet<Object>();

        private ValueStorage() {
        }

        public Map<Object, FieldNode> getValues() {
            return this.values;
        }

        public FieldNode get(Object key) {
            return this.values.get(key);
        }

        public boolean put(Object value, FieldNode fld) {
            if (this.duplicates.contains(value)) {
                this.values.remove(value);
                return true;
            }
            FieldNode prev = this.values.put(value, fld);
            if (prev != null) {
                this.values.remove(value);
                this.duplicates.add(value);
                return true;
            }
            return false;
        }

        public boolean contains(Object value) {
            return this.duplicates.contains(value) || this.values.containsKey(value);
        }

        void removeForCls(ClassNode cls) {
            Iterator<Map.Entry<Object, FieldNode>> it = this.values.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, FieldNode> entry = it.next();
                FieldNode field = entry.getValue();
                if (!field.getParentClass().equals(cls)) continue;
                it.remove();
            }
        }
    }
}

