/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.AnonymousClassAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.usage.UsageInfoVisitor;
import jadx.core.utils.ListUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="ProcessAnonymous", desc="Mark anonymous and lambda classes (for future inline)", runAfter={UsageInfoVisitor.class})
public class ProcessAnonymous
extends AbstractVisitor {
    private boolean inlineAnonymousClasses;

    @Override
    public void init(RootNode root) {
        this.inlineAnonymousClasses = root.getArgs().isInlineAnonymousClasses();
        if (!this.inlineAnonymousClasses) {
            return;
        }
        for (ClassNode cls : root.getClasses()) {
            ProcessAnonymous.markAnonymousClass(cls);
        }
        this.mergeAnonymousDeps(root);
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (this.inlineAnonymousClasses && cls.contains(AFlag.CLASS_UNLOADED)) {
            this.visitClassAndInners(cls);
        }
        return false;
    }

    private void visitClassAndInners(ClassNode cls) {
        ProcessAnonymous.markAnonymousClass(cls);
        cls.getInnerClasses().forEach(this::visitClassAndInners);
    }

    private static void markAnonymousClass(ClassNode cls) {
        if (!ProcessAnonymous.canBeAnonymous(cls)) {
            return;
        }
        MethodNode anonymousConstructor = ListUtils.filterOnlyOne(cls.getMethods(), MethodNode::isConstructor);
        if (anonymousConstructor == null) {
            return;
        }
        AnonymousClassAttr.InlineType inlineType = ProcessAnonymous.checkUsage(cls, anonymousConstructor);
        if (inlineType == null) {
            return;
        }
        ArgType baseType = ProcessAnonymous.getBaseType(cls);
        if (baseType == null) {
            return;
        }
        ClassNode outerCls = inlineType == AnonymousClassAttr.InlineType.INSTANCE_FIELD ? cls.getUseInMth().get(0).getParentClass() : anonymousConstructor.getUseIn().get(0).getParentClass();
        outerCls.addInlinedClass(cls);
        cls.addAttr((IJadxAttribute)new AnonymousClassAttr(outerCls, baseType, inlineType));
        cls.add(AFlag.DONT_GENERATE);
        anonymousConstructor.add(AFlag.ANONYMOUS_CONSTRUCTOR);
        ClassNode topOuterCls = outerCls.getTopParentClass();
        cls.removeDependency(topOuterCls);
        ListUtils.safeRemove(outerCls.getUseIn(), cls);
        if (cls.isTopClass()) {
            topOuterCls.removeDependency(cls);
            topOuterCls.addCodegenDep(cls);
        }
    }

    private static void undoAnonymousMark(ClassNode cls) {
        AnonymousClassAttr attr = cls.get(AType.ANONYMOUS_CLASS);
        ClassNode outerCls = attr.getOuterCls();
        cls.setDependencies(ListUtils.safeAdd(cls.getDependencies(), outerCls.getTopParentClass()));
        outerCls.setUseIn(ListUtils.safeAdd(outerCls.getUseIn(), cls));
        cls.remove(AType.ANONYMOUS_CLASS);
        cls.remove(AFlag.DONT_GENERATE);
        for (MethodNode mth : cls.getMethods()) {
            if (!mth.isConstructor()) continue;
            mth.remove(AFlag.ANONYMOUS_CONSTRUCTOR);
        }
        cls.addDebugComment("Anonymous mark cleared");
    }

    private void mergeAnonymousDeps(RootNode root) {
        HashMap<ClassNode, ClassNode> inlineMap = new HashMap<ClassNode, ClassNode>();
        HashMap<ClassNode, List> useMap = new HashMap<ClassNode, List>();
        for (ClassNode anonymousCls : root.getClasses()) {
            AnonymousClassAttr attr = anonymousCls.get(AType.ANONYMOUS_CLASS);
            if (attr == null) continue;
            ClassNode outerCls = attr.getOuterCls();
            ArrayList<ClassNode> list2 = (ArrayList<ClassNode>)useMap.get(outerCls);
            if (list2 == null || list2.isEmpty()) {
                list2 = new ArrayList<ClassNode>(2);
                useMap.put(outerCls, list2);
            }
            list2.add(anonymousCls);
            useMap.putIfAbsent(anonymousCls, Collections.emptyList());
            inlineMap.put(anonymousCls, outerCls);
        }
        if (inlineMap.isEmpty()) {
            return;
        }
        HashSet<ClassNode> added = new HashSet<ClassNode>();
        useMap.forEach((key, list) -> {
            if (list.isEmpty()) {
                added.clear();
                this.updateDeps((ClassNode)key, (Map<ClassNode, ClassNode>)inlineMap, (Set<ClassNode>)added);
            }
        });
        for (ClassNode cls : root.getClasses()) {
            List<ClassNode> deps = cls.getCodegenDeps();
            if (deps.size() <= 1) continue;
            added.clear();
            added.addAll(deps);
            deps.clear();
            deps.addAll(added);
            Collections.sort(deps);
        }
    }

    private void updateDeps(ClassNode leafCls, Map<ClassNode, ClassNode> inlineMap, Set<ClassNode> added) {
        ClassNode current = leafCls;
        while (true) {
            if (!added.add(current)) {
                current.addWarnComment("Loop in anonymous inline: " + current + ", path: " + added);
                added.forEach(ProcessAnonymous::undoAnonymousMark);
                return;
            }
            ClassNode next = inlineMap.get(current);
            if (next == null) break;
            current = next;
        }
        ClassNode topNode = current.getTopParentClass();
        if (added.size() <= 2) {
            return;
        }
        List<ClassNode> deps = topNode.getCodegenDeps();
        if (deps.isEmpty()) {
            deps = new ArrayList<ClassNode>(added.size());
            topNode.setCodegenDeps(deps);
        }
        for (ClassNode add : added) {
            deps.add(add.getTopParentClass());
        }
    }

    private static boolean canBeAnonymous(ClassNode cls) {
        if (cls.getAccessFlags().isSynthetic()) {
            return true;
        }
        String shortName = cls.getClassInfo().getShortName();
        if (shortName.contains("$") || Character.isDigit(shortName.charAt(0))) {
            return true;
        }
        if (cls.getUseIn().size() == 1 && cls.getUseInMth().size() == 1) {
            MethodNode useMth = cls.getUseInMth().get(0);
            return useMth.getMethodInfo().isClassInit() && useMth.getParentClass().isEnum();
        }
        return false;
    }

    private static AnonymousClassAttr.InlineType checkUsage(ClassNode cls, MethodNode ctr) {
        if (ctr.getUseIn().size() != 1 && !ProcessAnonymous.checkForCommonFieldInit(ctr)) {
            return null;
        }
        MethodNode ctrUseMth = ctr.getUseIn().get(0);
        ClassNode ctrUseCls = ctrUseMth.getParentClass();
        if (ctrUseCls.equals(cls)) {
            if (ProcessAnonymous.checkForInstanceFieldUsage(cls, ctr)) {
                return AnonymousClassAttr.InlineType.INSTANCE_FIELD;
            }
            return null;
        }
        if (ctrUseCls.getTopParentClass().equals(cls)) {
            return null;
        }
        if (!ProcessAnonymous.checkMethodsUsage(cls, ctr, ctrUseMth)) {
            return null;
        }
        for (FieldNode field : cls.getFields()) {
            for (MethodNode useMth : field.getUseIn()) {
                if (!ProcessAnonymous.badMethodUsage(cls, useMth, field.getAccessFlags())) continue;
                return null;
            }
        }
        return AnonymousClassAttr.InlineType.CONSTRUCTOR;
    }

    private static boolean checkMethodsUsage(ClassNode cls, MethodNode ctr, MethodNode ctrUseMth) {
        for (MethodNode mth : cls.getMethods()) {
            if (mth == ctr) continue;
            for (MethodNode useMth : mth.getUseIn()) {
                if (useMth.equals(ctrUseMth) || !ProcessAnonymous.badMethodUsage(cls, useMth, mth.getAccessFlags())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkForInstanceFieldUsage(ClassNode cls, MethodNode ctr) {
        MethodNode ctrUseMth = ctr.getUseIn().get(0);
        if (!ctrUseMth.getMethodInfo().isClassInit()) {
            return false;
        }
        FieldNode instFld = ListUtils.filterOnlyOne(cls.getFields(), f -> f.getAccessFlags().containsFlags(1, 8, 16) && f.getFieldInfo().getType().equals(cls.getClassInfo().getType()));
        if (instFld == null) {
            return false;
        }
        List<MethodNode> instFldUseIn = instFld.getUseIn();
        if (instFldUseIn.size() != 2 || !instFldUseIn.contains(ctrUseMth) || !instFldUseIn.containsAll(cls.getUseInMth())) {
            return false;
        }
        if (!ProcessAnonymous.checkMethodsUsage(cls, ctr, ctrUseMth)) {
            return false;
        }
        for (FieldNode field : cls.getFields()) {
            if (field == instFld) continue;
            for (MethodNode useMth : field.getUseIn()) {
                if (!ProcessAnonymous.badMethodUsage(cls, useMth, field.getAccessFlags())) continue;
                return false;
            }
        }
        instFld.add(AFlag.INLINE_INSTANCE_FIELD);
        return true;
    }

    private static boolean badMethodUsage(ClassNode cls, MethodNode useMth, AccessInfo accessFlags) {
        ClassNode useCls = useMth.getParentClass();
        if (useCls.equals(cls)) {
            return false;
        }
        if (accessFlags.isSynthetic()) {
            return !useCls.getParentClass().equals(cls);
        }
        return true;
    }

    private static boolean checkForCommonFieldInit(MethodNode ctrMth) {
        List<MethodNode> ctrUse = ctrMth.getUseIn();
        if (ctrUse.isEmpty()) {
            return false;
        }
        ClassNode firstUseCls = ctrUse.get(0).getParentClass();
        return ListUtils.allMatch(ctrUse, m -> m.isConstructor() && m.getParentClass().equals(firstUseCls));
    }

    @Nullable
    private static ArgType getBaseType(ClassNode cls) {
        int interfacesCount = cls.getInterfaces().size();
        if (interfacesCount > 1) {
            return null;
        }
        ArgType superCls = cls.getSuperClass();
        if (superCls == null || superCls.equals(ArgType.OBJECT)) {
            if (interfacesCount == 1) {
                return cls.getInterfaces().get(0);
            }
            return ArgType.OBJECT;
        }
        if (interfacesCount == 0) {
            return superCls;
        }
        ArgType interfaceType = cls.getInterfaces().get(0);
        if (cls.root().getClsp().isImplements(superCls.getObject(), interfaceType.getObject())) {
            return superCls;
        }
        if (cls.root().getArgs().isAllowInlineKotlinLambda() && superCls.getObject().equals("kotlin.jvm.internal.Lambda")) {
            return interfaceType;
        }
        return null;
    }
}

