/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

abstract class BasePolicyEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    @ProtoField(value=2)
    final String name;
    @ProtoField(value=3, collectionImplementation=HashSet.class)
    final Set<String> resources;
    @ProtoField(value=4, collectionImplementation=HashSet.class)
    final Set<String> resourceTypes;
    @ProtoField(value=5, collectionImplementation=HashSet.class)
    final Set<String> scopes;
    @ProtoField(value=6)
    final String serverId;

    BasePolicyEvent(String id, String name, Set<String> resources, Set<String> resourceTypes, Set<String> scopes, String serverId) {
        super(id);
        this.name = Objects.requireNonNull(name);
        this.resources = resources;
        this.resourceTypes = resourceTypes;
        this.scopes = scopes;
        this.serverId = Objects.requireNonNull(serverId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasePolicyEvent that = (BasePolicyEvent)o;
        return this.name.equals(that.name) && Objects.equals(this.resources, that.resources) && Objects.equals(this.resourceTypes, that.resourceTypes) && Objects.equals(this.scopes, that.scopes) && this.serverId.equals(that.serverId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.resources);
        result = 31 * result + Objects.hashCode(this.resourceTypes);
        result = 31 * result + Objects.hashCode(this.scopes);
        result = 31 * result + this.serverId.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s [id=%s, name=%s]", this.getClass().getSimpleName(), this.getId(), this.name);
    }
}

