/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.context.TenantIdentifierMismatchException;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractCurrentSessionContext
implements CurrentSessionContext {
    private final @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory;

    protected AbstractCurrentSessionContext(@UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory() {
        return this.factory;
    }

    protected @UnknownKeyFor @NonNull @Initialized SessionBuilder baseSessionBuilder() {
        SessionBuilderImplementor builder = this.factory.withOptions();
        CurrentTenantIdentifierResolver<Object> resolver = this.factory.getCurrentTenantIdentifierResolver();
        if (resolver != null) {
            builder.tenantIdentifier(resolver.resolveCurrentTenantIdentifier());
        }
        return builder;
    }

    protected void validateExistingSession(@UnknownKeyFor @NonNull @Initialized Session existingSession) {
        CurrentTenantIdentifierResolver<Object> resolver = this.factory.getCurrentTenantIdentifierResolver();
        if (resolver != null && resolver.validateExistingCurrentSessions()) {
            Object currentValue = resolver.resolveCurrentTenantIdentifier();
            JavaType<Object> tenantIdentifierJavaType = this.factory.getTenantIdentifierJavaType();
            if (!tenantIdentifierJavaType.areEqual(currentValue, existingSession.getTenantIdentifierValue())) {
                throw new TenantIdentifierMismatchException(String.format("Reported current tenant identifier [%s] did not match tenant identifier from existing session [%s]", tenantIdentifierJavaType.toString(currentValue), tenantIdentifierJavaType.toString(existingSession.getTenantIdentifierValue())));
            }
        }
    }
}

