/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.persister.entity.EntityPersister;

public class Association {
    private final @UnknownKeyFor @NonNull @Initialized EntityPersister owner;
    private final @UnknownKeyFor @NonNull @Initialized String associationPath;
    private final @UnknownKeyFor @NonNull @Initialized String role;

    public Association(@UnknownKeyFor @NonNull @Initialized EntityPersister owner, @UnknownKeyFor @NonNull @Initialized String associationPath) {
        this.owner = owner;
        this.associationPath = associationPath;
        this.role = owner.getEntityName() + "." + associationPath;
    }

    public @UnknownKeyFor @NonNull @Initialized EntityPersister getOwner() {
        return this.owner;
    }

    public @UnknownKeyFor @NonNull @Initialized String getAssociationPath() {
        return this.associationPath;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRole() {
        return this.role;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Association[" + this.role + "]";
    }
}

