/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonGeneratorImpl;
import org.eclipse.parsson.JsonMessages;
import org.eclipse.parsson.JsonPrettyGeneratorImpl;

class JsonWriterImpl
implements JsonWriter {
    private final JsonGeneratorImpl generator;
    private boolean writeDone;
    private final NoFlushOutputStream os;

    JsonWriterImpl(Writer writer, JsonContext jsonContext) {
        this.generator = jsonContext.prettyPrinting() ? new JsonPrettyGeneratorImpl(writer, jsonContext) : new JsonGeneratorImpl(writer, jsonContext);
        this.os = null;
    }

    JsonWriterImpl(OutputStream out, JsonContext jsonContext) {
        this(out, StandardCharsets.UTF_8, jsonContext);
    }

    JsonWriterImpl(OutputStream out, Charset charset, JsonContext jsonContext) {
        this.os = new NoFlushOutputStream(out);
        this.generator = jsonContext.prettyPrinting() ? new JsonPrettyGeneratorImpl(this.os, charset, jsonContext) : new JsonGeneratorImpl(this.os, charset, jsonContext);
    }

    public void writeArray(JsonArray array) {
        if (this.writeDone) {
            throw new IllegalStateException(JsonMessages.WRITER_WRITE_ALREADY_CALLED());
        }
        this.writeDone = true;
        this.generator.writeStartArray();
        for (JsonValue value : array) {
            this.generator.write(value);
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
        if (this.os != null) {
            this.generator.flush();
        }
    }

    public void writeObject(JsonObject object) {
        if (this.writeDone) {
            throw new IllegalStateException(JsonMessages.WRITER_WRITE_ALREADY_CALLED());
        }
        this.writeDone = true;
        this.generator.writeStartObject();
        for (Map.Entry e : object.entrySet()) {
            this.generator.write((String)e.getKey(), (JsonValue)e.getValue());
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
        if (this.os != null) {
            this.generator.flush();
        }
    }

    public void write(JsonStructure value) {
        if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else {
            this.writeObject((JsonObject)value);
        }
    }

    public void write(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                this.writeObject((JsonObject)value);
                return;
            }
            case ARRAY: {
                this.writeArray((JsonArray)value);
                return;
            }
        }
        if (this.writeDone) {
            throw new IllegalStateException(JsonMessages.WRITER_WRITE_ALREADY_CALLED());
        }
        this.writeDone = true;
        this.generator.write(value);
        this.generator.flushBuffer();
        if (this.os != null) {
            this.generator.flush();
        }
    }

    public void close() {
        this.writeDone = true;
        this.generator.close();
    }

    private static final class NoFlushOutputStream
    extends FilterOutputStream {
        public NoFlushOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() {
        }
    }
}

