/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Environment;
import org.keycloak.config.HostnameV2Options;
import org.keycloak.config.ProxyOptions;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.HttpPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.utils.SecureContextResolver;

public final class HostnameV2PropertyMappers {
    private static final String CONTEXT_WARNING = "the server is running in an insecure context. Secure contexts are required for full functionality, including cross-origin cookies.";
    private static final List<String> REMOVED_OPTIONS = Arrays.asList("hostname-admin-url", "hostname-path", "hostname-port", "hostname-strict-backchannel", "hostname-url", "proxy", "hostname-strict-https");

    private HostnameV2PropertyMappers() {
    }

    public static PropertyMapper<?>[] getHostnamePropertyMappers() {
        return (PropertyMapper[])Stream.of(PropertyMapper.fromOption(HostnameV2Options.HOSTNAME).to("kc.spi-hostname--v2--hostname").paramLabel("hostname|URL"), PropertyMapper.fromOption(HostnameV2Options.HOSTNAME_ADMIN).to("kc.spi-hostname--v2--hostname-admin").paramLabel("URL"), PropertyMapper.fromOption(HostnameV2Options.HOSTNAME_BACKCHANNEL_DYNAMIC).to("kc.spi-hostname--v2--hostname-backchannel-dynamic"), PropertyMapper.fromOption(HostnameV2Options.HOSTNAME_STRICT).to("kc.spi-hostname--v2--hostname-strict"), PropertyMapper.fromOption(HostnameV2Options.HOSTNAME_DEBUG)).map(b -> b.isEnabled(() -> Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.HOSTNAME_V2), "hostname:v2 feature is enabled").build()).toArray(PropertyMapper[]::new);
    }

    public static void validateConfig(Picocli picocli) {
        HostnameV2PropertyMappers.validateConfig(picocli::warn);
    }

    public static void validateConfig(Consumer<String> warn) {
        List<String> inUse = REMOVED_OPTIONS.stream().filter(s -> Configuration.getOptionalKcValue(s).isPresent()).toList();
        if (!inUse.isEmpty()) {
            warn.accept("Hostname v1 options %s are still in use, please review your configuration".formatted(inUse));
        }
        boolean isProd = "prod".equals(Environment.getProfile());
        boolean httpsEnabled = HttpPropertyMappers.isHttpsEnabled();
        String host = Configuration.getConfigValue(HostnameV2Options.HOSTNAME).getValue();
        String proxyHeaders = Configuration.getConfigValue(ProxyOptions.PROXY_HEADERS).getValue();
        if (host != null && HostnameV2PropertyMappers.validateFullHostname(httpsEnabled, isProd, host, proxyHeaders, warn)) {
            return;
        }
        if (httpsEnabled) {
            return;
        }
        if (proxyHeaders != null) {
            return;
        }
        if (isProd) {
            String warning = "the server is running in an insecure context. Secure contexts are required for full functionality, including cross-origin cookies. Also if you are using a proxy, requests from the proxy to the server will fail CORS checks with 403s because the wrong origin will be determined. Make sure `proxy-headers` are configured properly.";
            if (host == null) {
                warn.accept("With HTTPS not enabled, `proxy-headers` unset, and `hostname-strict=false`, " + warning);
            } else if (!SecureContextResolver.isLocal((String)host)) {
                warn.accept("Likely misconfiguration detected. With HTTPS not enabled, `proxy-headers` unset, and a non-URL `hostname`, " + warning);
            }
        }
    }

    static boolean validateFullHostname(boolean httpsEnabled, boolean isProd, String host, String proxyHeaders, Consumer<String> warn) {
        try {
            URL url = new URL(host);
            if (!url.getProtocol().toUpperCase().equals("HTTPS")) {
                if (isProd) {
                    if (!SecureContextResolver.isLocal((String)url.getHost())) {
                        warn.accept("Likely misconfiguration detected. `hostname` is configured to use HTTP instead of HTTPS, the server is running in an insecure context. Secure contexts are required for full functionality, including cross-origin cookies.");
                    }
                    if (httpsEnabled) {
                        warn.accept("Likely misconfiguration detected. HTTPS is enabled on the server, but `hostname` specifies HTTP.");
                    }
                }
            } else if (proxyHeaders == null && !httpsEnabled) {
                warn.accept("Likely misconfiguration detected. When using an edge proxy, you must use `proxy-headers`.");
            }
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

