/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import com.google.gson.annotations.JsonAdapter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.adapters.HoverTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

@JsonAdapter(value=HoverTypeAdapter.Factory.class)
public class Hover {
    @NonNull
    private Either<List<Either<String, MarkedString>>, MarkupContent> contents;
    private Range range;

    public Hover() {
    }

    public Hover(@NonNull List<Either<String, MarkedString>> contents) {
        this.setContents((List)Preconditions.checkNotNull(contents, (String)"contents"));
    }

    public Hover(@NonNull List<Either<String, MarkedString>> contents, Range range) {
        this.setContents((List)Preconditions.checkNotNull(contents, (String)"contents"));
        this.range = range;
    }

    public Hover(@NonNull MarkupContent contents) {
        this.setContents((MarkupContent)Preconditions.checkNotNull((Object)contents, (String)"contents"));
    }

    public Hover(@NonNull MarkupContent contents, Range range) {
        this.setContents((MarkupContent)Preconditions.checkNotNull((Object)contents, (String)"contents"));
        this.range = range;
    }

    public Hover(@NonNull Either<String, MarkedString> contents) {
        this.setContents(Arrays.asList((Either)Preconditions.checkNotNull(contents, (String)"contents")));
    }

    @NonNull
    public Either<List<Either<String, MarkedString>>, MarkupContent> getContents() {
        return this.contents;
    }

    public void setContents(@NonNull Either<List<Either<String, MarkedString>>, MarkupContent> contents) {
        this.contents = (Either)Preconditions.checkNotNull(contents, (String)"contents");
    }

    public void setContents(List<Either<String, MarkedString>> contents) {
        if (contents == null) {
            Preconditions.checkNotNull(contents, (String)"contents");
            this.contents = null;
            return;
        }
        this.contents = Either.forLeft(contents);
    }

    public void setContents(MarkupContent contents) {
        if (contents == null) {
            Preconditions.checkNotNull((Object)contents, (String)"contents");
            this.contents = null;
            return;
        }
        this.contents = Either.forRight((Object)contents);
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("contents", this.contents);
        b.add("range", (Object)this.range);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hover other = (Hover)obj;
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        return 31 * result + (this.range == null ? 0 : this.range.hashCode());
    }
}

