/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mdns.internal;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.mdns.MDNSClient;
import org.openhab.core.io.transport.mdns.MDNSService;
import org.openhab.core.io.transport.mdns.ServiceDescription;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class MDNSServiceImpl
implements MDNSService {
    private final Logger logger = LoggerFactory.getLogger(MDNSServiceImpl.class);
    private @Nullable MDNSClient mdnsClient;
    private final Set<ServiceDescription> servicesToRegisterQueue = new CopyOnWriteArraySet<ServiceDescription>();

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setMDNSClient(MDNSClient client) {
        this.mdnsClient = client;
        if (!this.servicesToRegisterQueue.isEmpty()) {
            Executors.newSingleThreadExecutor().execute(() -> {
                this.logger.debug("Registering {} queued services", (Object)this.servicesToRegisterQueue.size());
                for (ServiceDescription description : this.servicesToRegisterQueue) {
                    try {
                        MDNSClient localClient = this.mdnsClient;
                        if (localClient == null) break;
                        localClient.registerService(description);
                    }
                    catch (IOException e) {
                        this.logger.error("{}", (Object)e.getMessage());
                    }
                    catch (IllegalStateException e) {
                        this.logger.debug("Not registering service {}, because service is already deactivated!", (Object)description.serviceType);
                    }
                }
                this.servicesToRegisterQueue.clear();
            });
        }
    }

    protected void unsetMDNSClient(MDNSClient mdnsClient) {
        this.mdnsClient = null;
        mdnsClient.unregisterAllServices();
    }

    @Override
    public void registerService(ServiceDescription description) {
        MDNSClient localClient = this.mdnsClient;
        if (localClient == null) {
            this.servicesToRegisterQueue.add(description);
        } else {
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    localClient.registerService(description);
                }
                catch (IOException e) {
                    this.logger.error("{}", (Object)e.getMessage());
                }
                catch (IllegalStateException e) {
                    this.logger.debug("Not registering service {}, because service is already deactivated!", (Object)serviceDescription.serviceType);
                }
            });
        }
    }

    @Override
    public void unregisterService(ServiceDescription description) {
        if (this.mdnsClient != null) {
            this.mdnsClient.unregisterService(description);
        }
    }

    protected void unregisterAllServices() {
        if (this.mdnsClient != null) {
            this.mdnsClient.unregisterAllServices();
        }
    }

    @Deactivate
    public void deactivate() {
        this.unregisterAllServices();
        if (this.mdnsClient != null) {
            this.mdnsClient.close();
            this.logger.debug("mDNS service has been stopped");
        }
    }
}

