/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.UnicastSubject;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowBoundarySupplier<T, B>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final Callable<? extends ObservableSource<B>> other;
    final int capacityHint;

    public ObservableWindowBoundarySupplier(ObservableSource<T> source, Callable<? extends ObservableSource<B>> other, int capacityHint) {
        super(source);
        this.other = other;
        this.capacityHint = capacityHint;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> observer) {
        WindowBoundaryMainObserver parent = new WindowBoundaryMainObserver(observer, this.capacityHint, this.other);
        this.source.subscribe(parent);
    }

    static final class WindowBoundaryInnerObserver<T, B>
    extends DisposableObserver<B> {
        final WindowBoundaryMainObserver<T, B> parent;
        boolean done;

        WindowBoundaryInnerObserver(WindowBoundaryMainObserver<T, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.parent.innerNext(this);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.innerComplete();
        }
    }

    static final class WindowBoundaryMainObserver<T, B>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 2233020065421370272L;
        final Observer<? super Observable<T>> downstream;
        final int capacityHint;
        final AtomicReference<WindowBoundaryInnerObserver<T, B>> boundaryObserver;
        static final WindowBoundaryInnerObserver<Object, Object> BOUNDARY_DISPOSED = new WindowBoundaryInnerObserver(null);
        final AtomicInteger windows;
        final MpscLinkedQueue<Object> queue;
        final AtomicThrowable errors;
        final AtomicBoolean stopWindows;
        final Callable<? extends ObservableSource<B>> other;
        static final Object NEXT_WINDOW = new Object();
        Disposable upstream;
        volatile boolean done;
        UnicastSubject<T> window;

        WindowBoundaryMainObserver(Observer<? super Observable<T>> downstream, int capacityHint, Callable<? extends ObservableSource<B>> other) {
            this.downstream = downstream;
            this.capacityHint = capacityHint;
            this.boundaryObserver = new AtomicReference();
            this.windows = new AtomicInteger(1);
            this.queue = new MpscLinkedQueue();
            this.errors = new AtomicThrowable();
            this.stopWindows = new AtomicBoolean();
            this.other = other;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                this.queue.offer(NEXT_WINDOW);
                this.drain();
            }
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.disposeBoundary();
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.disposeBoundary();
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (this.stopWindows.compareAndSet(false, true)) {
                this.disposeBoundary();
                if (this.windows.decrementAndGet() == 0) {
                    this.upstream.dispose();
                }
            }
        }

        void disposeBoundary() {
            Disposable d = this.boundaryObserver.getAndSet(BOUNDARY_DISPOSED);
            if (d != null && d != BOUNDARY_DISPOSED) {
                d.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.stopWindows.get();
        }

        @Override
        public void run() {
            if (this.windows.decrementAndGet() == 0) {
                this.upstream.dispose();
            }
        }

        void innerNext(WindowBoundaryInnerObserver<T, B> sender) {
            this.boundaryObserver.compareAndSet(sender, null);
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        void innerError(Throwable e) {
            this.upstream.dispose();
            if (this.errors.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void innerComplete() {
            this.upstream.dispose();
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<Observable<UnicastSubject<T>>> downstream = this.downstream;
            MpscLinkedQueue<Object> queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                boolean empty;
                if (this.windows.get() == 0) {
                    queue.clear();
                    this.window = null;
                    return;
                }
                UnicastSubject<Object> w = this.window;
                boolean d = this.done;
                if (d && errors.get() != null) {
                    queue.clear();
                    Throwable ex = errors.terminate();
                    if (w != null) {
                        this.window = null;
                        w.onError(ex);
                    }
                    downstream.onError(ex);
                    return;
                }
                Object v = queue.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    Throwable ex = errors.terminate();
                    if (ex == null) {
                        if (w != null) {
                            this.window = null;
                            w.onComplete();
                        }
                        downstream.onComplete();
                    } else {
                        if (w != null) {
                            this.window = null;
                            w.onError(ex);
                        }
                        downstream.onError(ex);
                    }
                    return;
                }
                if (!empty) {
                    ObservableSource<B> otherSource;
                    if (v != NEXT_WINDOW) {
                        w.onNext(v);
                        continue;
                    }
                    if (w != null) {
                        this.window = null;
                        w.onComplete();
                    }
                    if (this.stopWindows.get()) continue;
                    w = UnicastSubject.create(this.capacityHint, this);
                    this.window = w;
                    this.windows.getAndIncrement();
                    try {
                        otherSource = ObjectHelper.requireNonNull(this.other.call(), "The other Callable returned a null ObservableSource");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        errors.addThrowable(ex);
                        this.done = true;
                        continue;
                    }
                    WindowBoundaryInnerObserver bo = new WindowBoundaryInnerObserver(this);
                    if (!this.boundaryObserver.compareAndSet(null, bo)) continue;
                    otherSource.subscribe(bo);
                    downstream.onNext(w);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

