/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) ^ (- 0u)) => uvec4(66u, 72u, 87u, 75u)
 * (uvec4(66u, 72u, 87u, 75u) ^ (- 6u)) => uvec4(4294967224u, 4294967218u, 4294967213u, 4294967217u)
 * (uvec4(66u, 72u, 87u, 75u) ^ (- 12u)) => uvec4(4294967222u, 4294967228u, 4294967203u, 4294967231u)
 * (uvec4(66u, 72u, 87u, 75u) ^ (- 32u)) => uvec4(4294967202u, 4294967208u, 4294967223u, 4294967211u)
 * (uvec4(66u, 72u, 87u, 75u) ^ (- 74u)) => uvec4(4294967284u, 4294967294u, 4294967265u, 4294967293u)
 * (uvec4(24u, 40u, 23u, 74u) ^ (- 0u)) => uvec4(24u, 40u, 23u, 74u)
 * (uvec4(24u, 40u, 23u, 74u) ^ (- 6u)) => uvec4(4294967266u, 4294967250u, 4294967277u, 4294967216u)
 * (uvec4(24u, 40u, 23u, 74u) ^ (- 12u)) => uvec4(4294967276u, 4294967260u, 4294967267u, 4294967230u)
 * (uvec4(24u, 40u, 23u, 74u) ^ (- 32u)) => uvec4(4294967288u, 4294967240u, 4294967287u, 4294967210u)
 * (uvec4(24u, 40u, 23u, 74u) ^ (- 74u)) => uvec4(4294967214u, 4294967198u, 4294967201u, 4294967292u)
 */
#version 130

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) ^ (- 0u)), uvec4(66u, 72u, 87u, 75u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) ^ (- 6u)), uvec4(4294967224u, 4294967218u, 4294967213u, 4294967217u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) ^ (- 12u)), uvec4(4294967222u, 4294967228u, 4294967203u, 4294967231u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) ^ (- 32u)), uvec4(4294967202u, 4294967208u, 4294967223u, 4294967211u))) ? 1 : -1] array3;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) ^ (- 74u)), uvec4(4294967284u, 4294967294u, 4294967265u, 4294967293u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) ^ (- 0u)), uvec4(24u, 40u, 23u, 74u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) ^ (- 6u)), uvec4(4294967266u, 4294967250u, 4294967277u, 4294967216u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) ^ (- 12u)), uvec4(4294967276u, 4294967260u, 4294967267u, 4294967230u))) ? 1 : -1] array7;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) ^ (- 32u)), uvec4(4294967288u, 4294967240u, 4294967287u, 4294967210u))) ? 1 : -1] array8;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) ^ (- 74u)), uvec4(4294967214u, 4294967198u, 4294967201u, 4294967292u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
