/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class SmokeyProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_DATE_RECORD = 0;
    public static final int MSG_DATE_RECORD_ACK = 1;

    public SmokeyProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static void sendResponse(Channel channel, SocketAddress remoteAddress, ByteBuf id, int index, int report) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeBytes("SM".getBytes(StandardCharsets.US_ASCII));
            response.writeByte(3);
            response.writeByte(1);
            response.writeBytes(id);
            response.writeInt((int)ChronoUnit.SECONDS.between(Instant.parse("2000-01-01T00:00:00.00Z"), Instant.now()));
            response.writeByte(index);
            response.writeByte(report - 512);
            int checksum = -2656;
            for (int i = 0; i < response.readableBytes(); i += 2) {
                checksum = (short)(checksum ^ response.getShortLE(i));
            }
            response.writeShort(checksum);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        ByteBuf id = buf.readSlice(8);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)id));
        if (deviceSession == null) {
            return null;
        }
        if (type == 0) {
            int i;
            int count;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("versionFw", buf.readUnsignedShort());
            int status = buf.readUnsignedShort();
            position.set("status", status);
            DateBuilder dateBuilder = new DateBuilder().setDate(2000, 1, 1).addSeconds(buf.readUnsignedInt());
            this.getLastLocation(position, dateBuilder.getDate());
            short index = buf.readUnsignedByte();
            position.set("index", Integer.valueOf(index));
            int report = buf.readUnsignedShort();
            buf.readUnsignedShort();
            position.set("battery", buf.readUnsignedShort());
            Network network = new Network();
            if (report != 515) {
                count = 1;
                if (report != 512) {
                    count = buf.readUnsignedByte();
                }
                for (i = 0; i < count; ++i) {
                    int mcc = buf.readUnsignedShort();
                    int mnc = buf.readUnsignedShort();
                    int lac = buf.readUnsignedShort();
                    int cid = buf.readUnsignedShort();
                    if (i == 0) {
                        buf.readByte();
                    }
                    byte rssi = buf.readByte();
                    network.addCellTower(CellTower.from(mcc, mnc, lac, cid, rssi));
                }
            }
            if (report == 514 || report == 515) {
                count = buf.readUnsignedByte();
                for (i = 0; i < count; ++i) {
                    buf.readerIndex(buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0) + 1);
                    String mac = String.format("%02x:%02x:%02x:%02x:%02x:%02x", buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                    network.addWifiAccessPoint(WifiAccessPoint.from(mac, buf.readByte()));
                }
            }
            position.setNetwork(network);
            SmokeyProtocolDecoder.sendResponse(channel, remoteAddress, id, index, report);
            return position;
        }
        return null;
    }
}

