/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.mysql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.mysql.conf.MySQLDriver;
import org.apache.guacamole.auth.mysql.conf.MySQLEnvironment;
import org.apache.guacamole.auth.mysql.conf.MySQLSSLMode;
import org.apache.guacamole.properties.CaseSensitivity;
import org.mybatis.guice.datasource.helper.JdbcHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLAuthenticationProviderModule
implements Module {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLAuthenticationProviderModule.class);
    private final Properties myBatisProperties = new Properties();
    private final Properties driverProperties = new Properties();
    private MySQLDriver mysqlDriver;

    public MySQLAuthenticationProviderModule(MySQLEnvironment environment) throws GuacamoleException {
        String clientPassword;
        File clientStore;
        String trustPassword;
        this.myBatisProperties.setProperty("mybatis.environment.id", "guacamole");
        this.myBatisProperties.setProperty("JDBC.host", environment.getMySQLHostname());
        this.myBatisProperties.setProperty("JDBC.port", String.valueOf(environment.getMySQLPort()));
        this.myBatisProperties.setProperty("JDBC.schema", environment.getMySQLDatabase());
        this.myBatisProperties.setProperty("JDBC.autoCommit", "false");
        this.myBatisProperties.setProperty("mybatis.pooled.pingEnabled", "true");
        this.myBatisProperties.setProperty("mybatis.pooled.pingQuery", "SELECT 1");
        this.driverProperties.setProperty("characterEncoding", "UTF-8");
        this.driverProperties.setProperty("allowMultiQueries", "true");
        MySQLSSLMode sslMode = environment.getMySQLSSLMode();
        this.driverProperties.setProperty("sslMode", sslMode.getDriverValue());
        if (sslMode == MySQLSSLMode.DISABLED) {
            this.driverProperties.setProperty("useSSL", "false");
        } else {
            this.driverProperties.setProperty("useSSL", "true");
        }
        File trustStore = environment.getMySQLSSLTrustStore();
        if (trustStore != null) {
            this.driverProperties.setProperty("trustCertificateKeyStoreUrl", trustStore.toURI().toString());
        }
        if ((trustPassword = environment.getMySQLSSLTrustPassword()) != null) {
            this.driverProperties.setProperty("trustCertificateKeyStorePassword", trustPassword);
        }
        if ((clientStore = environment.getMySQLSSLClientStore()) != null) {
            this.driverProperties.setProperty("clientCertificateKeyStoreUrl", clientStore.toURI().toString());
        }
        if ((clientPassword = environment.getMYSQLSSLClientPassword()) != null) {
            this.driverProperties.setProperty("clientCertificateKeyStorePassword", clientPassword);
        }
        this.mysqlDriver = environment.getMySQLDriver();
        TimeZone serverTz = environment.getServerTimeZone();
        if (serverTz != null) {
            this.driverProperties.setProperty("serverTimezone", serverTz.getID());
        }
        if (environment.getCaseSensitivity() != CaseSensitivity.DISABLED) {
            LOGGER.warn("The MySQL module is currently configured to support case-sensitive username and/or group name comparisons, however, the default collations for MySQL databases do not support case-sensitive string comparisons. If you want identifiers within Guacamole to be treated as case-sensitive, further database configuration may be required.");
        }
    }

    public void configure(Binder binder) {
        switch (this.mysqlDriver) {
            case MYSQL: {
                JdbcHelper.MySQL.configure(binder);
                break;
            }
            case MARIADB: {
                JdbcHelper.MariaDB.configure(binder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("A driver has been specified that is not supported by this module.");
            }
        }
        Names.bindProperties((Binder)binder, (Properties)this.myBatisProperties);
        binder.bind(Properties.class).annotatedWith((Annotation)Names.named((String)"JDBC.driverProperties")).toInstance((Object)this.driverProperties);
    }
}

