/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth.websphere;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.ui.AuthenticationDetailsSource;
import org.springframework.security.ui.preauth.websphere.WASSecurityHelper;
import org.springframework.security.ui.preauth.websphere.WebSpherePreAuthenticatedAuthenticationDetailsSource;
import org.springframework.util.Assert;

public class WebSphere2SpringSecurityPropagationInterceptor
implements MethodInterceptor {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$springframework$security$ui$preauth$websphere$WebSphere2SpringSecurityPropagationInterceptor == null ? (class$org$springframework$security$ui$preauth$websphere$WebSphere2SpringSecurityPropagationInterceptor = WebSphere2SpringSecurityPropagationInterceptor.class$("org.springframework.security.ui.preauth.websphere.WebSphere2SpringSecurityPropagationInterceptor")) : class$org$springframework$security$ui$preauth$websphere$WebSphere2SpringSecurityPropagationInterceptor));
    private AuthenticationManager authenticationManager = null;
    private AuthenticationDetailsSource authenticationDetailsSource = new WebSpherePreAuthenticatedAuthenticationDetailsSource();
    static /* synthetic */ Class class$org$springframework$security$ui$preauth$websphere$WebSphere2SpringSecurityPropagationInterceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        try {
            LOG.debug((Object)"Performing Spring Security authentication with WebSphere credentials");
            this.authenticateSpringSecurityWithWASCredentials(this);
            LOG.debug((Object)"Proceeding with method invocation");
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            LOG.debug((Object)"Clearing Spring Security security context");
            this.clearSpringSecurityContext();
        }
    }

    private final void authenticateSpringSecurityWithWASCredentials(Object aContext) {
        Assert.notNull((Object)this.authenticationManager);
        Assert.notNull((Object)this.authenticationDetailsSource);
        String userName = WASSecurityHelper.getCurrentUserName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating authentication request for user " + userName));
        }
        PreAuthenticatedAuthenticationToken authRequest = new PreAuthenticatedAuthenticationToken(userName, null);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails(null));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authentication request for user " + userName + ": " + authRequest));
        }
        Authentication authResponse = this.authenticationManager.authenticate(authRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authentication response for user " + userName + ": " + authResponse));
        }
        SecurityContextHolder.getContext().setAuthentication(authResponse);
    }

    private final void clearSpringSecurityContext() {
        SecurityContextHolder.clearContext();
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthenticationDetailsSource getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

