/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGInterval
extends PGobject
implements Serializable,
Cloneable {
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private double seconds;
    private static final DecimalFormat secondsFormat = new DecimalFormat("0.00####");

    public PGInterval() {
        this.setType("interval");
    }

    public PGInterval(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGInterval(int years, int months, int days, int hours, int minutes, double seconds) {
        this();
        this.setValue(years, months, days, hours, minutes, seconds);
    }

    public void setValue(String value) throws SQLException {
        boolean ISOFormat;
        boolean bl = ISOFormat = !value.startsWith("@");
        if (!ISOFormat && value.length() == 3 && value.charAt(2) == '0') {
            this.setValue(0, 0, 0, 0, 0, 0.0);
            return;
        }
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        try {
            String valueToken = null;
            value = value.replace('+', ' ').replace('@', ' ');
            StringTokenizer st = new StringTokenizer(value);
            int i = 1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (i & true) {
                    int endHours = token.indexOf(58);
                    if (endHours == -1) {
                        valueToken = token;
                    } else {
                        int offset = token.charAt(0) == '-' ? 1 : 0;
                        hours = this.nullSafeIntGet(token.substring(offset + 0, endHours));
                        minutes = this.nullSafeIntGet(token.substring(endHours + 1, endHours + 3));
                        int endMinutes = token.indexOf(58, endHours + 1);
                        if (endMinutes != -1) {
                            seconds = this.nullSafeDoubleGet(token.substring(endMinutes + 1));
                        }
                        if (offset == 1) {
                            hours = -hours;
                            minutes = -minutes;
                            seconds = -seconds;
                        }
                        valueToken = null;
                    }
                } else if (token.startsWith("year")) {
                    years = this.nullSafeIntGet(valueToken);
                } else if (token.startsWith("mon")) {
                    months = this.nullSafeIntGet(valueToken);
                } else if (token.startsWith("day")) {
                    days = this.nullSafeIntGet(valueToken);
                } else if (token.startsWith("hour")) {
                    hours = this.nullSafeIntGet(valueToken);
                } else if (token.startsWith("min")) {
                    minutes = this.nullSafeIntGet(valueToken);
                } else if (token.startsWith("sec")) {
                    seconds = this.nullSafeDoubleGet(valueToken);
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion of interval failed"), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)e);
        }
        if (!ISOFormat && value.endsWith("ago")) {
            this.setValue(-years, -months, -days, -hours, -minutes, -seconds);
        } else {
            this.setValue(years, months, days, hours, minutes, seconds);
        }
    }

    public void setValue(int years, int months, int days, int hours, int minutes, double seconds) {
        this.setYears(years);
        this.setMonths(months);
        this.setDays(days);
        this.setHours(hours);
        this.setMinutes(minutes);
        this.setSeconds(seconds);
    }

    public String getValue() {
        return this.years + " years " + this.months + " mons " + this.days + " days " + this.hours + " hours " + this.minutes + " mins " + secondsFormat.format(this.seconds) + " secs";
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public int getMonths() {
        return this.months;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setSeconds(double seconds) {
        this.seconds = seconds;
    }

    public void add(Calendar cal) {
        int microseconds;
        int milliseconds = (microseconds + ((microseconds = (int)(this.getSeconds() * 1000000.0)) < 0 ? -500 : 500)) / 1000;
        cal.add(14, milliseconds);
        cal.add(12, this.getMinutes());
        cal.add(10, this.getHours());
        cal.add(5, this.getDays());
        cal.add(2, this.getMonths());
        cal.add(1, this.getYears());
    }

    public void add(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.add(cal);
        date.setTime(cal.getTime().getTime());
    }

    private int nullSafeIntGet(String value) throws NumberFormatException {
        return value == null ? 0 : Integer.parseInt(value);
    }

    private double nullSafeDoubleGet(String value) throws NumberFormatException {
        return value == null ? 0.0 : Double.parseDouble(value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PGInterval)) {
            return false;
        }
        PGInterval pgi = (PGInterval)obj;
        return pgi.years == this.years && pgi.months == this.months && pgi.days == this.days && pgi.hours == this.hours && pgi.minutes == this.minutes && Double.doubleToLongBits(pgi.seconds) == Double.doubleToLongBits(this.seconds);
    }

    public int hashCode() {
        return ((((((217 + (int)Double.doubleToLongBits(this.seconds)) * 31 + this.minutes) * 31 + this.hours) * 31 + this.days) * 31 + this.months) * 31 + this.years) * 31;
    }

    public Object clone() {
        return new PGInterval(this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    static {
        DecimalFormatSymbols dfs = secondsFormat.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        secondsFormat.setDecimalFormatSymbols(dfs);
    }
}

