/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.eclipse.californium.elements.util.NotForAndroid;
import org.eclipse.californium.scandium.dtls.cipher.CCMBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class AeadBlockCipher {
    public static final String AES_CCM = "AES/CCM";

    public static final boolean isSupported(String transformation, int keyLength) {
        try {
            Cipher cipher = AES_CCM.equals(transformation) ? (Cipher)CCMBlockCipher.CIPHER.current() : Cipher.getInstance(transformation);
            if (cipher != null) {
                int maxAllowedKeyLengthBits = Cipher.getMaxAllowedKeyLength(cipher.getAlgorithm());
                return keyLength * 8 <= maxAllowedKeyLengthBits;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return false;
    }

    public static final byte[] decrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] crypted, int cryptedOffset, int cryptedLength) throws GeneralSecurityException {
        if (AES_CCM.equals(suite.getTransformation())) {
            return CCMBlockCipher.decrypt(key, nonce, additionalData, crypted, cryptedOffset, cryptedLength, suite.getMacLength());
        }
        return AeadBlockCipher.jreDecrypt(suite, key, nonce, additionalData, crypted, cryptedOffset, cryptedLength);
    }

    public static final byte[] encrypt(int outputOffset, CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] message) throws GeneralSecurityException {
        if (AES_CCM.equals(suite.getTransformation())) {
            return CCMBlockCipher.encrypt(outputOffset, key, nonce, additionalData, message, suite.getMacLength());
        }
        return AeadBlockCipher.jreEncrypt(outputOffset, suite, key, nonce, additionalData, message);
    }

    @NotForAndroid
    private static final byte[] jreDecrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] crypted, int cryptedOffset, int cryptedLength) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(2, (Key)key, parameterSpec);
        cipher.updateAAD(additionalData);
        return cipher.doFinal(crypted, cryptedOffset, cryptedLength);
    }

    @NotForAndroid
    private static final byte[] jreEncrypt(int outputOffset, CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] message) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(1, (Key)key, parameterSpec);
        cipher.updateAAD(additionalData);
        int length = cipher.getOutputSize(message.length);
        byte[] result = new byte[length + outputOffset];
        cipher.doFinal(message, 0, message.length, result, outputOffset);
        return result;
    }
}

