/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic;

import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.CriticismEvent;
import ca.sqlpower.architect.ddl.critic.CriticismListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CriticismBucket {
    private final List<Criticism> criticisms = new ArrayList<Criticism>();
    private final List<CriticismListener> listeners = new ArrayList<CriticismListener>();

    public void updateCriticismsToMatch(List<Criticism> newCriticisms) {
        this.clearCriticisms();
        this.criticisms.addAll(newCriticisms);
        int index = this.criticisms.size();
        for (Criticism newCriticism : newCriticisms) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).criticismAdded(new CriticismEvent(newCriticism, index));
            }
            ++index;
        }
    }

    private void clearCriticisms() {
        ArrayList<Criticism> oldCriticisms = new ArrayList<Criticism>(this.criticisms);
        this.criticisms.clear();
        for (int i = oldCriticisms.size() - 1; i >= 0; --i) {
            Criticism oldCriticism = oldCriticisms.get(i);
            for (int j = this.listeners.size() - 1; j >= 0; --j) {
                this.listeners.get(j).criticismRemoved(new CriticismEvent(oldCriticism, i));
            }
        }
    }

    public List<Criticism> getCriticisms() {
        return Collections.unmodifiableList(this.criticisms);
    }

    public List<Criticism> getCriticismsByObject(Object subject) {
        ArrayList<Criticism> selectedCriticisms = new ArrayList<Criticism>();
        for (Criticism criticism : this.criticisms) {
            if (!criticism.getSubject().equals(subject)) continue;
            selectedCriticisms.add(criticism);
        }
        return selectedCriticisms;
    }

    public Collection<Object> getCriticismSubjects() {
        HashSet<Object> subjects = new HashSet<Object>();
        for (Criticism criticism : this.criticisms) {
            subjects.add(criticism.getSubject());
        }
        return subjects;
    }

    public void addCriticismListener(CriticismListener l) {
        this.listeners.add(l);
    }

    public void removeCriticismListener(CriticismListener l) {
        this.listeners.remove(l);
    }
}

