/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDays;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.sdef.AbstractSDEFRecord;
import net.sf.mpxj.sdef.Context;
import net.sf.mpxj.sdef.SDEFField;
import net.sf.mpxj.sdef.StringField;

class CalendarRecord
extends AbstractSDEFRecord {
    private static final SDEFField[] FIELDS = new SDEFField[]{new StringField("Calendar Code", 1), new StringField("Workdays", 7), new StringField("Calendar Description", 30)};

    CalendarRecord() {
    }

    @Override
    protected SDEFField[] getFieldDefinitions() {
        return FIELDS;
    }

    @Override
    public void process(Context context) {
        ProjectCalendar calendar = context.addCalendar(this.getString(0));
        calendar.setName(this.getString(2));
        String flags = this.getString(1);
        for (Day day : Day.values()) {
            boolean workingDay = flags.charAt(day.getValue() - 1) == 'Y';
            calendar.setWorkingDay(day, workingDay);
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            if (!workingDay) continue;
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
        }
        context.getEventManager().fireCalendarReadEvent(calendar);
    }
}

