/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.ValuedAIObject;

public abstract class Wish
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(Wish.class.getName());
    protected Location destination;
    protected TransportableAIObject transportable;
    private static final String DESTINATION_TAG = "destination";
    private static final String TRANSPORTABLE_TAG = "transportable";

    public Wish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.destination = null;
        this.transportable = null;
    }

    public Wish(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        AIColony ac = this.getDestinationAIColony();
        if (ac != null) {
            ac.addWish(this);
        }
    }

    public boolean shouldBeStored() {
        return this.transportable != null;
    }

    public TransportableAIObject getTransportable() {
        return this.transportable;
    }

    public void setTransportable(TransportableAIObject transportable) {
        this.transportable = transportable;
    }

    public final Location getDestination() {
        return this.destination;
    }

    public final AIColony getDestinationAIColony() {
        return this.destination instanceof Colony ? this.getAIMain().getAIColony((Colony)this.destination) : null;
    }

    public abstract boolean satisfiedBy(Unit var1);

    public abstract <T extends AbstractGoods> boolean satisfiedBy(T var1);

    @Override
    public void dispose() {
        this.destination = null;
        this.transportable = null;
        super.dispose();
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.transportable != null) {
            result = result.combine(this.transportable.checkIntegrity(fix, lb));
        }
        if (this.destination == null) {
            lb.add("\n  Wish destination null for: ", this.getId());
            result = result.fail();
        } else if (((FreeColGameObject)((Object)this.destination)).isDisposed()) {
            lb.add("\n  Wish destination disposed for: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.destination != null) {
            xw.writeAttribute(DESTINATION_TAG, this.destination.getId());
            if (this.transportable != null) {
                xw.writeAttribute(TRANSPORTABLE_TAG, this.transportable.getId());
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.destination = xr.getLocationAttribute(aiMain.getGame(), DESTINATION_TAG, false);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Wish)) {
            return false;
        }
        Wish other = (Wish)o;
        return Utils.equals(this.destination, other.destination) && Utils.equals(this.transportable, other.transportable) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.destination);
        return 37 * hash + Utils.hashCode(this.transportable);
    }
}

