/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.function.Function;
import org.openstreetmap.josm.actions.AbstractShowHistoryAction;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;

class ShowHistoryAction
extends AbstractShowHistoryAction {
    private transient PrimitiveId primitiveId;

    ShowHistoryAction() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            this.run();
        }
    }

    public void setPrimitiveId(PrimitiveId pid) {
        this.primitiveId = pid;
        this.updateEnabledState();
    }

    public void run() {
        HistoryBrowserDialogManager.getInstance().showHistory(Collections.singleton(this.primitiveId));
    }

    public void updateEnabledState() {
        this.setEnabled(this.primitiveId != null && !this.primitiveId.isNew());
    }

    static class DoubleClickAdapter
    extends MouseAdapter {
        private final Function<MouseEvent, PrimitiveId> primitiveIdFunction;

        DoubleClickAdapter(Function<MouseEvent, PrimitiveId> primitiveIdFunction) {
            this.primitiveIdFunction = primitiveIdFunction;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            PrimitiveId pid = this.primitiveIdFunction.apply(e);
            if (pid == null || pid.isNew()) {
                return;
            }
            HistoryBrowserDialogManager.getInstance().showHistory(Collections.singleton(pid));
        }
    }
}

