/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayContainsFunction;
import org.hibernate.dialect.function.array.ArrayHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.spi.TypeConfiguration;

public class H2ArrayContainsFunction
extends AbstractArrayContainsFunction {
    private final int maximumArraySize;

    public H2ArrayContainsFunction(boolean nullable, int maximumArraySize, TypeConfiguration typeConfiguration) {
        super(nullable, typeConfiguration);
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        JdbcMapping needleType;
        Expression haystackExpression = (Expression)sqlAstArguments.get(0);
        Expression needleExpression = (Expression)sqlAstArguments.get(1);
        JdbcMappingContainer needleTypeContainer = needleExpression.getExpressionType();
        JdbcMapping jdbcMapping = needleType = needleTypeContainer == null ? null : needleTypeContainer.getSingleJdbcMapping();
        if (needleType == null || needleType instanceof BasicPluralType) {
            LOG.deprecatedArrayContainsWithArray();
            sqlAppender.append('(');
            if (ArrayHelper.isNullable(haystackExpression)) {
                haystackExpression.accept(walker);
                sqlAppender.append(" is not null and ");
            }
            if (ArrayHelper.isNullable(needleExpression)) {
                needleExpression.accept(walker);
                sqlAppender.append(" is not null and ");
            }
            if (!this.nullable) {
                sqlAppender.append("not array_contains(");
                needleExpression.accept(walker);
                sqlAppender.append(",null) and ");
            }
            sqlAppender.append("not ");
            sqlAppender.append("exists(select array_get(");
            walker.render(needleExpression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
            sqlAppender.append(",t.i) from system_range(1,");
            sqlAppender.append(Integer.toString(this.maximumArraySize));
            sqlAppender.append(") t(i) where array_length(");
            needleExpression.accept(walker);
            sqlAppender.append(")>=t.i");
            sqlAppender.append(" except ");
            sqlAppender.append("select array_get(");
            haystackExpression.accept(walker);
            sqlAppender.append(",t.i) from system_range(1,");
            sqlAppender.append(Integer.toString(this.maximumArraySize));
            sqlAppender.append(") t(i) where array_length(");
            haystackExpression.accept(walker);
            sqlAppender.append(")>=t.i))");
        } else {
            sqlAppender.append("array_contains(");
            haystackExpression.accept(walker);
            sqlAppender.append(',');
            needleExpression.accept(walker);
            sqlAppender.append(')');
        }
    }
}

