/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filters.parser;

import java.math.BigDecimal;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.logstash.filters.parser.TimestampParser;

public class JodaParser
implements TimestampParser {
    private final DateTimeFormatter parser;
    private final boolean hasYear;
    private final boolean hasZone;
    private final String timezone;
    private final Clock clock = defaultClock;
    public static final Clock wallClock;
    private static Clock defaultClock;

    public static void setDefaultClock(Clock clock) {
        defaultClock = clock;
    }

    public JodaParser(String pattern, Locale locale, String timezone) {
        this.timezone = timezone;
        this.hasYear = pattern.contains("Y") || pattern.contains("y");
        this.hasZone = pattern.contains("Z");
        this.parser = DateTimeFormat.forPattern((String)pattern).withDefaultYear(this.clock.read().getYear()).withLocale(locale).withZone(DateTimeZone.forID((String)timezone));
    }

    @Override
    public Instant parse(String value) {
        if (this.hasYear) {
            return new Instant(this.parser.parseMillis(value));
        }
        return this.parseAndGuessYear(this.parser, value);
    }

    @Override
    public Instant parse(Long value) {
        throw new IllegalArgumentException("Expected a string value, but got a long (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parse(Double value) {
        throw new IllegalArgumentException("Expected a string value, but got a double (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parse(BigDecimal value) {
        throw new IllegalArgumentException("Expected a string value, but got a bigdecimal (" + value + "). Cannot parse date.");
    }

    @Override
    public Instant parseWithTimeZone(String value, String timezone) {
        DateTimeZone tz = DateTimeZone.forID((String)timezone);
        DateTimeFormatter parserWithZone = this.parser.withZone(tz);
        if (this.hasYear) {
            return new Instant(parserWithZone.parseMillis(value));
        }
        return this.parseAndGuessYear(parserWithZone, value);
    }

    private Instant parseAndGuessYear(DateTimeFormatter parser, String value) {
        DateTime dateTime = this.hasZone ? parser.parseDateTime(value) : parser.withZoneUTC().parseLocalDateTime(value).toDateTime(parser.getZone());
        int month = dateTime.getMonthOfYear();
        DateTime now = this.clock.read();
        int eventYear = month == 12 && now.getMonthOfYear() == 1 ? now.getYear() - 1 : (month == 1 && now.getMonthOfYear() == 12 ? now.getYear() + 1 : now.getYear());
        return dateTime.withYear(eventYear).toInstant();
    }

    static {
        defaultClock = wallClock = () -> new DateTime();
    }

    public static interface Clock {
        public DateTime read();
    }
}

