/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.OutsideRangeForDataTypeException;
import org.apache.derby.client.am.SqlException;

final class CrossConverters {
    public static final int UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final BigDecimal bdMaxByteValue__ = BigDecimal.valueOf(127L);
    private static final BigDecimal bdMinByteValue__ = BigDecimal.valueOf(-128L);
    private static final BigDecimal bdMaxShortValue__ = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue__ = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue__ = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue__ = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue__ = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue__ = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue__ = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue__ = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue__ = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue__ = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdZero__ = BigDecimal.valueOf(0L);
    private static final BigDecimal bdOne__ = BigDecimal.valueOf(1L);
    private final Agent agent_;

    CrossConverters(Agent agent) {
        this.agent_ = agent;
    }

    final Object setObject(int targetType, boolean source) throws SqlException {
        short numVal = source ? (short)1 : 0;
        switch (targetType) {
            case -7: 
            case 16: {
                return source;
            }
            case 5: {
                return numVal;
            }
            case 4: {
                return (int)numVal;
            }
            case -5: {
                return (long)numVal;
            }
            case 7: {
                return Float.valueOf(numVal);
            }
            case 8: {
                return (double)numVal;
            }
            case 3: {
                return BigDecimal.valueOf(numVal);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "boolean", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, byte source) throws SqlException {
        return this.setObject(targetType, (short)source);
    }

    final Object setObject(int targetType, short source) throws SqlException {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0;
            }
            case 5: {
                return source;
            }
            case 4: {
                return (int)source;
            }
            case -5: {
                return (long)source;
            }
            case 7: {
                return Float.valueOf(source);
            }
            case 8: {
                return (double)source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "byte", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, int source) throws SqlException {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0;
            }
            case 5: {
                if (source > Short.MAX_VALUE || source < Short.MIN_VALUE) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)source;
            }
            case 4: {
                return source;
            }
            case -5: {
                return (long)source;
            }
            case 7: {
                return Float.valueOf(source);
            }
            case 8: {
                return (double)source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "int", ClientTypes.getTypeString(targetType));
    }

    final boolean setBooleanFromObject(Object source, int sourceType) throws SqlException {
        switch (sourceType) {
            case 5: {
                return this.getBooleanFromShort((Short)source);
            }
            case 4: {
                return this.getBooleanFromInt((Integer)source);
            }
            case -5: {
                return this.getBooleanFromLong(((BigInteger)source).longValue());
            }
            case 7: {
                return this.getBooleanFromFloat(((Float)source).floatValue());
            }
            case 8: {
                return this.getBooleanFromDouble((Double)source);
            }
            case 3: {
                return this.getBooleanFromLong(((BigDecimal)source).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getBooleanFromString((String)source);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, ClientTypes.getTypeString(sourceType), "boolean");
    }

    final byte setByteFromObject(Object source, int sourceType) throws SqlException {
        switch (sourceType) {
            case 5: {
                return this.getByteFromShort((Short)source);
            }
            case 4: {
                return this.getByteFromInt((Integer)source);
            }
            case -5: {
                return this.getByteFromLong(((BigInteger)source).longValue());
            }
            case 7: {
                return this.getByteFromFloat(((Float)source).floatValue());
            }
            case 8: {
                return this.getByteFromDouble((Double)source);
            }
            case 3: {
                return this.getByteFromLong(((BigDecimal)source).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getByteFromString((String)source);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, ClientTypes.getTypeString(sourceType), "byte");
    }

    final Object setObject(int targetType, long source) throws SqlException {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0L;
            }
            case 5: {
                if (source > 32767L || source < -32768L) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)source;
            }
            case 4: {
                if (source > Integer.MAX_VALUE || source < Integer.MIN_VALUE) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)source;
            }
            case -5: {
                return source;
            }
            case 7: {
                return Float.valueOf(source);
            }
            case 8: {
                return (double)source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "long", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, float source) throws SqlException {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0.0f;
            }
            case 5: {
                if (source > 32767.0f || source < -32768.0f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)source;
            }
            case 4: {
                if (source > 2.1474836E9f || source < -2.1474836E9f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)source;
            }
            case -5: {
                if (source > 9.223372E18f || source < -9.223372E18f) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return (long)source;
            }
            case 7: {
                if (source == Float.POSITIVE_INFINITY || source == Float.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf(source);
            }
            case 8: {
                if ((double)source == Double.POSITIVE_INFINITY || (double)source == Double.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return Double.valueOf(String.valueOf(source));
            }
            case 3: {
                return new BigDecimal(String.valueOf(source));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "float", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, double source) throws SqlException {
        switch (targetType) {
            case -7: 
            case 16: {
                return source != 0.0;
            }
            case 5: {
                if (source > 32767.0 || source < -32768.0) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return (short)source;
            }
            case 4: {
                if (source > 2.147483647E9 || source < -2.147483648E9) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return (int)source;
            }
            case -5: {
                if (source > 9.223372036854776E18 || source < -9.223372036854776E18) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return (long)source;
            }
            case 7: {
                if (source > 3.4028234663852886E38 || source < -3.4028234663852886E38) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf((float)source);
            }
            case 8: {
                if (source == Double.POSITIVE_INFINITY || source == Double.NEGATIVE_INFINITY) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return source;
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "double", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, BigDecimal source) throws SqlException {
        switch (targetType) {
            case -7: 
            case 16: {
                return BigDecimal.valueOf(0L).compareTo(source) != 0;
            }
            case 5: {
                if (source.compareTo(bdMaxShortValue__) == 1 || source.compareTo(bdMinShortValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
                }
                return source.shortValue();
            }
            case 4: {
                if (source.compareTo(bdMaxIntValue__) == 1 || source.compareTo(bdMinIntValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
                }
                return source.intValue();
            }
            case -5: {
                if (source.compareTo(bdMaxLongValue__) == 1 || source.compareTo(bdMinLongValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
                }
                return source.longValue();
            }
            case 7: {
                if (source.compareTo(bdMaxFloatValue__) == 1 || source.compareTo(bdMinFloatValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "REAL");
                }
                return Float.valueOf(source.floatValue());
            }
            case 8: {
                if (source.compareTo(bdMaxDoubleValue__) == 1 || source.compareTo(bdMinDoubleValue__) == -1) {
                    throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
                }
                return source.doubleValue();
            }
            case 3: {
                return source;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.Math.BigDecimal", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, Date source) throws SqlException {
        switch (targetType) {
            case 91: {
                return source;
            }
            case 93: {
                return new Timestamp(source.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Date", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, Time source) throws SqlException {
        switch (targetType) {
            case 92: {
                return source;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Time", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, Timestamp source) throws SqlException {
        switch (targetType) {
            case 93: {
                return source;
            }
            case 92: {
                return new Time(source.getTime());
            }
            case 91: {
                return new Date(source.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Timestamp", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetDriverType, String source) throws SqlException {
        try {
            switch (targetDriverType) {
                case -7: 
                case 16: {
                    String cleanSource = source.trim().toUpperCase(Locale.ENGLISH);
                    if (cleanSource.equals("UNKNOWN")) {
                        return null;
                    }
                    if (cleanSource.equals("TRUE")) {
                        return Boolean.TRUE;
                    }
                    if (cleanSource.equals("FALSE")) {
                        return Boolean.FALSE;
                    }
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), ClientTypes.getTypeString(targetDriverType));
                }
                case 5: {
                    return Short.valueOf(source);
                }
                case 4: {
                    return Integer.valueOf(source);
                }
                case -5: {
                    return Long.valueOf(source);
                }
                case 7: {
                    return Float.valueOf(source);
                }
                case 8: {
                    return Double.valueOf(source);
                }
                case 3: {
                    return new BigDecimal(source);
                }
                case 91: {
                    return CrossConverters.date_valueOf(source, null);
                }
                case 92: {
                    return CrossConverters.time_valueOf(source, null);
                }
                case 93: {
                    return CrossConverters.timestamp_valueOf(source, null);
                }
                case -1: 
                case 1: 
                case 12: {
                    return source;
                }
                case 2005: {
                    return new ClientClob(this.agent_, source);
                }
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "String", ClientTypes.getTypeString(targetDriverType));
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, ClientTypes.getTypeString(targetDriverType));
        }
    }

    public static int getInputJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -6: 
            case 5: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 8;
            }
        }
        return jdbcType;
    }

    final Object setObject(int targetType, byte[] source) throws SqlException {
        switch (targetType) {
            case -4: 
            case -3: 
            case -2: {
                return source;
            }
            case 2004: {
                return new ClientBlob(source, this.agent_, 0);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "byte[]", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, Reader source, int length) throws SqlException {
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromReader(source, length);
            }
            case 2005: {
                if (length == Integer.MIN_VALUE) {
                    return new ClientClob(this.agent_, source);
                }
                return new ClientClob(this.agent_, source, length);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.Reader", ClientTypes.getTypeString(targetType));
    }

    private String setStringFromReader(Reader r, int length) throws SqlException {
        StringWriter sw = new StringWriter();
        try {
            int read = r.read();
            int totalRead = 0;
            while (read != -1) {
                ++totalRead;
                sw.write(read);
                read = r.read();
            }
            if (length != Integer.MIN_VALUE && length != totalRead) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw SqlException.javaException(this.agent_.logWriter_, e);
        }
    }

    final Object setObjectFromCharacterStream(int targetType, InputStream source, Charset encoding, int length) throws SqlException {
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromStream(source, encoding, length);
            }
            case 2005: {
                if (length == Integer.MIN_VALUE) {
                    return new ClientClob(this.agent_, source, encoding);
                }
                return new ClientClob(this.agent_, source, encoding, length);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.InputStream", ClientTypes.getTypeString(targetType));
    }

    private String setStringFromStream(InputStream is, Charset encoding, int length) throws SqlException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalRead = 0;
        try {
            int read = is.read();
            while (read != -1) {
                ++totalRead;
                baos.write(read);
                read = is.read();
            }
        }
        catch (IOException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), e, e.getClass().getName(), e.getMessage());
        }
        if (length != Integer.MIN_VALUE && length != totalRead) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
        }
        return new String(baos.toByteArray(), encoding);
    }

    final Object setObject(int targetType, Blob source) throws SqlException {
        switch (targetType) {
            case 2004: {
                return source;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Blob", ClientTypes.getTypeString(targetType));
    }

    final Object setObjectFromBinaryStream(int targetType, InputStream source, int length) throws SqlException {
        switch (targetType) {
            case -4: 
            case -3: 
            case -2: {
                return this.setBytesFromStream(source, length);
            }
            case 2004: {
                if (length == Integer.MIN_VALUE) {
                    return new ClientBlob(this.agent_, source);
                }
                return new ClientBlob(this.agent_, source, length);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.io.InputStream", ClientTypes.getTypeString(targetType));
    }

    private byte[] setBytesFromStream(InputStream is, int length) throws SqlException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalRead = 0;
        try {
            int read = is.read();
            while (read != -1) {
                ++totalRead;
                baos.write(read);
                read = is.read();
            }
            if (length != Integer.MIN_VALUE && length != totalRead) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"), new Object[0]);
            }
        }
        catch (IOException e) {
            throw SqlException.javaException(this.agent_.logWriter_, e);
        }
        return baos.toByteArray();
    }

    final Object setObject(int targetType, Clob source) throws SqlException {
        switch (targetType) {
            case 2005: {
                return source;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), "java.sql.Clob", ClientTypes.getTypeString(targetType));
    }

    final Object setObject(int targetType, Object source) throws SqlException {
        if (source == null) {
            return null;
        }
        if (source instanceof Boolean) {
            return this.setObject(targetType, (Boolean)source);
        }
        if (source instanceof Integer) {
            return this.setObject(targetType, (Integer)source);
        }
        if (source instanceof Long) {
            return this.setObject(targetType, (Long)source);
        }
        if (source instanceof Float) {
            return this.setObject(targetType, ((Float)source).floatValue());
        }
        if (source instanceof Double) {
            return this.setObject(targetType, (Double)source);
        }
        if (source instanceof BigDecimal) {
            return this.setObject(targetType, (BigDecimal)source);
        }
        if (source instanceof Date) {
            return this.setObject(targetType, (Date)source);
        }
        if (source instanceof Time) {
            return this.setObject(targetType, (Time)source);
        }
        if (source instanceof Timestamp) {
            return this.setObject(targetType, (Timestamp)source);
        }
        if (source instanceof String) {
            return this.setObject(targetType, (String)source);
        }
        if (source instanceof byte[]) {
            return this.setObject(targetType, (byte[])source);
        }
        if (source instanceof Blob) {
            return this.setObject(targetType, (Blob)source);
        }
        if (source instanceof Clob) {
            return this.setObject(targetType, (Clob)source);
        }
        if (source instanceof Array) {
            return this.setObject(targetType, (Array)source);
        }
        if (source instanceof Ref) {
            return this.setObject(targetType, (Ref)source);
        }
        if (source instanceof Short) {
            return this.setObject(targetType, (Short)source);
        }
        if (source instanceof Byte) {
            return this.setObject(targetType, (Byte)source);
        }
        if (source instanceof BigInteger) {
            return this.setObject(targetType, new BigDecimal((BigInteger)source));
        }
        if (source instanceof java.util.Date) {
            return this.setObject(targetType, new Timestamp(((java.util.Date)source).getTime()));
        }
        if (source instanceof Calendar) {
            return this.setObject(targetType, new Timestamp(((Calendar)source).getTime().getTime()));
        }
        if (targetType == 2000) {
            return source;
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), source.getClass().getName(), ClientTypes.getTypeString(targetType));
    }

    final boolean getBooleanFromShort(short source) throws SqlException {
        return source != 0;
    }

    final boolean getBooleanFromInt(int source) throws SqlException {
        return source != 0;
    }

    final boolean getBooleanFromLong(long source) throws SqlException {
        return source != 0L;
    }

    final boolean getBooleanFromFloat(float source) throws SqlException {
        return source != 0.0f;
    }

    final boolean getBooleanFromDouble(double source) throws SqlException {
        return source != 0.0;
    }

    final boolean getBooleanFromString(String source) {
        String trimmed = source.trim();
        return !trimmed.equals("0") && !trimmed.equals("false");
    }

    final byte getByteFromShort(short source) throws SqlException {
        if (source > 127 || source < -128) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)source;
    }

    final byte getByteFromInt(int source) throws SqlException {
        if (source > 127 || source < -128) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)source;
    }

    final byte getByteFromLong(long source) throws SqlException {
        if (source > 127L || source < -128L) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)source;
    }

    final byte getByteFromFloat(float source) throws SqlException {
        if (source > 127.0f || source < -128.0f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)source;
    }

    final byte getByteFromDouble(double source) throws SqlException {
        if (source > 127.0 || source < -128.0) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "TINYINT");
        }
        return (byte)source;
    }

    final byte getByteFromBoolean(boolean source) throws SqlException {
        return source ? (byte)1 : 0;
    }

    final byte getByteFromString(String source) throws SqlException {
        try {
            return CrossConverters.parseByte(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, "byte");
        }
    }

    final short getShortFromInt(int source) throws SqlException {
        if (source > Short.MAX_VALUE || source < Short.MIN_VALUE) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)source;
    }

    final short getShortFromLong(long source) throws SqlException {
        if (source > 32767L || source < -32768L) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)source;
    }

    final short getShortFromFloat(float source) throws SqlException {
        if (source > 32767.0f || source < -32768.0f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)source;
    }

    final short getShortFromDouble(double source) throws SqlException {
        if (source > 32767.0 || source < -32768.0) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "SMALLINT");
        }
        return (short)source;
    }

    final short getShortFromBoolean(boolean source) throws SqlException {
        return source ? (short)1 : 0;
    }

    final short getShortFromString(String source) throws SqlException {
        try {
            return CrossConverters.parseShort(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, "short");
        }
    }

    final int getIntFromLong(long source) throws SqlException {
        if (source > Integer.MAX_VALUE || source < Integer.MIN_VALUE) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)source;
    }

    final int getIntFromFloat(float source) throws SqlException {
        if (source > 2.1474836E9f || source < -2.1474836E9f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)source;
    }

    final int getIntFromDouble(double source) throws SqlException {
        if (source > 2.147483647E9 || source < -2.147483648E9) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "INTEGER");
        }
        return (int)source;
    }

    final int getIntFromBoolean(boolean source) throws SqlException {
        return source ? 1 : 0;
    }

    final int getIntFromString(String source) throws SqlException {
        try {
            return CrossConverters.parseInt(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, "int");
        }
    }

    final long getLongFromFloat(float source) throws SqlException {
        if (source > 9.223372E18f || source < -9.223372E18f) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
        }
        return (long)source;
    }

    final long getLongFromDouble(double source) throws SqlException {
        if (source > 9.223372036854776E18 || source < -9.223372036854776E18) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "BIGINT");
        }
        return (long)source;
    }

    final long getLongFromBoolean(boolean source) throws SqlException {
        return source ? 1L : 0L;
    }

    final long getLongFromString(String source) throws SqlException {
        try {
            return CrossConverters.parseLong(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, "long");
        }
    }

    final float getFloatFromDouble(double source) throws SqlException {
        if (Float.isInfinite((float)source)) {
            throw new OutsideRangeForDataTypeException(this.agent_.logWriter_, "DOUBLE");
        }
        return (float)source;
    }

    final float getFloatFromBoolean(boolean source) throws SqlException {
        return source ? 1.0f : 0.0f;
    }

    final float getFloatFromString(String source) throws SqlException {
        try {
            return Float.parseFloat(source.trim());
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, "float");
        }
    }

    final double getDoubleFromBoolean(boolean source) throws SqlException {
        return source ? 1.0 : 0.0;
    }

    final double getDoubleFromString(String source) throws SqlException {
        try {
            return Double.parseDouble(source.trim());
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, "double");
        }
    }

    final BigDecimal getBigDecimalFromString(String source) throws SqlException {
        try {
            return new BigDecimal(source.trim());
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), e, "java.math.BigDecimal");
        }
    }

    final String getStringFromBytes(byte[] bytes) throws SqlException {
        StringBuffer stringBuffer = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            String hexForByte = Integer.toHexString(bytes[i] & 0xFF);
            if (hexForByte.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(hexForByte);
        }
        return stringBuffer.toString();
    }

    final Date getDateFromString(String source, Calendar cal) throws SqlException {
        try {
            return CrossConverters.date_valueOf(source, cal);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), e, new Object[0]);
        }
    }

    final Time getTimeFromString(String source, Calendar cal) throws SqlException {
        try {
            return CrossConverters.time_valueOf(source, cal);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), e, new Object[0]);
        }
    }

    final Timestamp getTimestampFromString(String source, Calendar cal) throws SqlException {
        try {
            return CrossConverters.timestamp_valueOf(source, cal);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), e, new Object[0]);
        }
    }

    private static Date date_valueOf(String s, Calendar cal) {
        String formatError = "JDBC Date format must be yyyy-mm-dd";
        if (s == null) {
            throw new IllegalArgumentException(formatError);
        }
        s = s.trim();
        if (cal == null) {
            return Date.valueOf(s);
        }
        cal.clear();
        CrossConverters.initDatePortion(cal, s);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    private static void initDatePortion(Calendar cal, String date) {
        if (date.length() != 10 || date.charAt(4) != '-' || date.charAt(7) != '-') {
            throw new IllegalArgumentException();
        }
        int year = CrossConverters.digit(date.charAt(0)) * 1000 + CrossConverters.digit(date.charAt(1)) * 100 + CrossConverters.digit(date.charAt(2)) * 10 + CrossConverters.digit(date.charAt(3));
        int month = CrossConverters.digit(date.charAt(5)) * 10 + CrossConverters.digit(date.charAt(6)) - 1;
        int day = CrossConverters.digit(date.charAt(8)) * 10 + CrossConverters.digit(date.charAt(9));
        cal.set(year, month, day);
    }

    private static int digit(char ch) {
        int result = Character.digit(ch, 10);
        if (result == -1) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static Time time_valueOf(String s, Calendar cal) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s = s.trim();
        if (cal == null) {
            return Time.valueOf(s);
        }
        cal.clear();
        CrossConverters.initTimePortion(cal, s);
        cal.set(1970, 0, 1);
        return new Time(cal.getTimeInMillis());
    }

    private static void initTimePortion(Calendar cal, String time) {
        if (time.length() != 8 || time.charAt(2) != ':' || time.charAt(5) != ':') {
            throw new IllegalArgumentException();
        }
        int hour = CrossConverters.digit(time.charAt(0)) * 10 + CrossConverters.digit(time.charAt(1));
        int minute = CrossConverters.digit(time.charAt(3)) * 10 + CrossConverters.digit(time.charAt(4));
        int second = CrossConverters.digit(time.charAt(6)) * 10 + CrossConverters.digit(time.charAt(7));
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
    }

    private static Timestamp timestamp_valueOf(String s, Calendar cal) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s = s.trim();
        if (cal == null) {
            return Timestamp.valueOf(s);
        }
        cal.clear();
        String[] dateAndTime = s.split(" ");
        if (dateAndTime.length != 2) {
            throw new IllegalArgumentException();
        }
        String dateString = dateAndTime[0];
        String timeAndNanoString = dateAndTime[1];
        CrossConverters.initDatePortion(cal, dateString);
        String[] timeAndNanos = timeAndNanoString.split("\\.");
        if (timeAndNanos.length < 1 || timeAndNanos.length > 2) {
            throw new IllegalArgumentException();
        }
        String timeString = timeAndNanos[0];
        CrossConverters.initTimePortion(cal, timeString);
        int nanos = 0;
        if (timeAndNanos.length > 1) {
            String nanoString = timeAndNanos[1];
            int extraZeros = 9 - nanoString.length();
            if (extraZeros < 0) {
                throw new IllegalArgumentException();
            }
            nanos = Integer.parseInt(nanoString);
            for (int i = 0; i < extraZeros; ++i) {
                nanos *= 10;
            }
        }
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        return ts;
    }

    private static byte parseByte(String s) throws NumberFormatException {
        int i = CrossConverters.parseInt(s);
        if (i < -128 || i > 127) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    private static short parseShort(String s) throws NumberFormatException {
        int i = CrossConverters.parseInt(s);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    private static int parseInt(String s) throws NumberFormatException {
        int digit;
        int limit;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max == 0) {
            throw new NumberFormatException(s);
        }
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / 10;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                throw new NumberFormatException(s);
            }
            result = -digit;
        }
        while (i < max) {
            char c;
            if ((c = s.charAt(i++)) == ' ') {
                CrossConverters.skipPadding(s, i, max);
                break;
            }
            digit = Character.digit(c, 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            if (result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(s);
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    private static long parseLong(String s) throws NumberFormatException {
        int digit;
        long limit;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max == 0) {
            throw new NumberFormatException(s);
        }
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long multmin = limit / 10L;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                throw new NumberFormatException(s);
            }
            result = -digit;
        }
        while (i < max) {
            char c;
            if ((c = s.charAt(i++)) == ' ') {
                CrossConverters.skipPadding(s, i, max);
                break;
            }
            digit = Character.digit(c, 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            if (result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(s);
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    private static void skipPadding(String s, int i, int length) throws NumberFormatException {
        while (i < length) {
            if (s.charAt(i++) == ' ') continue;
            throw new NumberFormatException(s);
        }
    }
}

