/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.AzureActiveDirectoryTokenProvider;
import com.microsoft.azure.eventhubs.BatchOptions;
import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataBatch;
import com.microsoft.azure.eventhubs.EventHubClientOptions;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.EventHubRuntimeInformation;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.ITokenProvider;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.PartitionRuntimeInformation;
import com.microsoft.azure.eventhubs.PartitionSender;
import com.microsoft.azure.eventhubs.ProxyConfiguration;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.impl.EventHubClientImpl;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public interface EventHubClient {
    public static final String DEFAULT_CONSUMER_GROUP_NAME = "$Default";

    public static EventHubClient createFromConnectionStringSync(String connectionString, ScheduledExecutorService executor) throws EventHubException, IOException {
        return EventHubClient.createFromConnectionStringSync(connectionString, null, executor);
    }

    public static EventHubClient createFromConnectionStringSync(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor) throws EventHubException, IOException {
        return ExceptionUtil.syncWithIOException(() -> EventHubClient.createFromConnectionString(connectionString, retryPolicy, executor).get());
    }

    public static EventHubClient createFromConnectionStringSync(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration configuration) throws EventHubException, IOException {
        return ExceptionUtil.syncWithIOException(() -> EventHubClient.createFromConnectionString(connectionString, retryPolicy, executor, configuration).get());
    }

    public static EventHubClient createFromConnectionStringSync(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration configuration, Duration maximumSilentTime) throws EventHubException, IOException {
        return ExceptionUtil.syncWithIOException(() -> EventHubClient.createFromConnectionString(connectionString, retryPolicy, executor, configuration, maximumSilentTime).get());
    }

    public static CompletableFuture<EventHubClient> createFromConnectionString(String connectionString, ScheduledExecutorService executor) throws IOException {
        return EventHubClient.createFromConnectionString(connectionString, null, executor);
    }

    public static CompletableFuture<EventHubClient> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor) throws IOException {
        return EventHubClientImpl.create(connectionString, retryPolicy, executor, null);
    }

    public static CompletableFuture<EventHubClient> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration proxyConfiguration) throws IOException {
        return EventHubClientImpl.create(connectionString, retryPolicy, executor, proxyConfiguration);
    }

    public static CompletableFuture<EventHubClient> createFromConnectionString(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration proxyConfiguration, Duration maximumSilentTime) throws IOException {
        return EventHubClientImpl.create(connectionString, retryPolicy, executor, proxyConfiguration, maximumSilentTime);
    }

    public static CompletableFuture<EventHubClient> createWithAzureActiveDirectory(URI endpointAddress, String eventHubName, AzureActiveDirectoryTokenProvider.AuthenticationCallback authCallback, String authority, ScheduledExecutorService executor, EventHubClientOptions options) throws IOException {
        AzureActiveDirectoryTokenProvider tokenProvider = new AzureActiveDirectoryTokenProvider(authCallback, authority, null);
        return EventHubClient.createWithTokenProvider(endpointAddress, eventHubName, tokenProvider, executor, options);
    }

    public static CompletableFuture<EventHubClient> createWithTokenProvider(URI endpointAddress, String eventHubName, ITokenProvider tokenProvider, ScheduledExecutorService executor, EventHubClientOptions options) throws IOException {
        return EventHubClientImpl.create(endpointAddress, eventHubName, tokenProvider, executor, options);
    }

    public String getEventHubName();

    public EventDataBatch createBatch(BatchOptions var1) throws EventHubException;

    default public EventDataBatch createBatch() throws EventHubException {
        return this.createBatch(new BatchOptions());
    }

    default public void sendSync(EventData data) throws EventHubException {
        ExceptionUtil.syncVoid(() -> this.send(data).get());
    }

    public CompletableFuture<Void> send(EventData var1);

    default public void sendSync(Iterable<EventData> eventDatas) throws EventHubException {
        ExceptionUtil.syncVoid(() -> this.send(eventDatas).get());
    }

    public CompletableFuture<Void> send(Iterable<EventData> var1);

    default public void sendSync(EventDataBatch eventDatas) throws EventHubException {
        ExceptionUtil.syncVoid(() -> this.send(eventDatas).get());
    }

    public CompletableFuture<Void> send(EventDataBatch var1);

    default public void sendSync(EventData eventData, String partitionKey) throws EventHubException {
        ExceptionUtil.syncVoid(() -> this.send(eventData, partitionKey).get());
    }

    public CompletableFuture<Void> send(EventData var1, String var2);

    default public void sendSync(Iterable<EventData> eventDatas, String partitionKey) throws EventHubException {
        ExceptionUtil.syncVoid(() -> this.send(eventDatas, partitionKey).get());
    }

    public CompletableFuture<Void> send(Iterable<EventData> var1, String var2);

    default public PartitionSender createPartitionSenderSync(String partitionId) throws EventHubException, IllegalArgumentException {
        return ExceptionUtil.syncWithIllegalArgException(() -> this.createPartitionSender(partitionId).get());
    }

    public CompletableFuture<PartitionSender> createPartitionSender(String var1) throws EventHubException;

    default public PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, EventPosition eventPosition) throws EventHubException {
        return ExceptionUtil.sync(() -> this.createReceiver(consumerGroupName, partitionId, eventPosition).get());
    }

    public CompletableFuture<PartitionReceiver> createReceiver(String var1, String var2, EventPosition var3) throws EventHubException;

    default public PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, EventPosition eventPosition, ReceiverOptions receiverOptions) throws EventHubException {
        return ExceptionUtil.sync(() -> this.createReceiver(consumerGroupName, partitionId, eventPosition, receiverOptions).get());
    }

    public CompletableFuture<PartitionReceiver> createReceiver(String var1, String var2, EventPosition var3, ReceiverOptions var4) throws EventHubException;

    default public PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, EventPosition eventPosition, long epoch) throws EventHubException {
        return ExceptionUtil.sync(() -> this.createEpochReceiver(consumerGroupName, partitionId, eventPosition, epoch).get());
    }

    public CompletableFuture<PartitionReceiver> createEpochReceiver(String var1, String var2, EventPosition var3, long var4) throws EventHubException;

    default public PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, EventPosition eventPosition, long epoch, ReceiverOptions receiverOptions) throws EventHubException {
        return ExceptionUtil.sync(() -> this.createEpochReceiver(consumerGroupName, partitionId, eventPosition, epoch, receiverOptions).get());
    }

    public CompletableFuture<PartitionReceiver> createEpochReceiver(String var1, String var2, EventPosition var3, long var4, ReceiverOptions var6) throws EventHubException;

    public CompletableFuture<EventHubRuntimeInformation> getRuntimeInformation();

    public CompletableFuture<PartitionRuntimeInformation> getPartitionRuntimeInformation(String var1);

    public CompletableFuture<Void> close();

    public void closeSync() throws EventHubException;
}

