/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ext;

import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.QueueFactoryExt;
import org.logstash.execution.AbstractWrappedQueueExt;
import org.logstash.execution.QueueReadClientBase;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.ext.JrubyMemoryReadClientExt;
import org.logstash.ext.JrubyMemoryWriteClientExt;

@JRubyClass(name={"WrappedSynchronousQueue"})
public final class JrubyWrappedSynchronousQueueExt
extends AbstractWrappedQueueExt {
    private static final long serialVersionUID = 1L;
    private transient BlockingQueue<JrubyEventExtLibrary.RubyEvent> queue;
    private QueueFactoryExt.BatchMetricMode batchMetricMode;

    public JrubyWrappedSynchronousQueueExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    private JrubyWrappedSynchronousQueueExt(Ruby runtime, RubyClass metaClass, int size, QueueFactoryExt.BatchMetricMode batchMetricMode) {
        super(runtime, metaClass);
        this.queue = new ArrayBlockingQueue<JrubyEventExtLibrary.RubyEvent>(size);
        this.batchMetricMode = Objects.requireNonNull(batchMetricMode, "batchMetricMode setting must be non-null");
    }

    @JRubyMethod
    public JrubyWrappedSynchronousQueueExt initialize(ThreadContext context, IRubyObject size, IRubyObject batchMetricMode) {
        if (!JavaUtil.isJavaObject((IRubyObject)batchMetricMode)) {
            throw new IllegalArgumentException(String.format("Failed to instantiate JrubyWrappedSynchronousQueueExt with <%s:%s>", batchMetricMode.getClass().getName(), batchMetricMode));
        }
        int typedSize = ((RubyNumeric)size).getIntValue();
        this.queue = new ArrayBlockingQueue<JrubyEventExtLibrary.RubyEvent>(typedSize);
        Objects.requireNonNull(batchMetricMode, "batchMetricMode setting must be non-null");
        this.batchMetricMode = (QueueFactoryExt.BatchMetricMode)((Object)JavaUtil.unwrapJavaObject((IRubyObject)batchMetricMode));
        return this;
    }

    public static JrubyWrappedSynchronousQueueExt create(ThreadContext context, int size, QueueFactoryExt.BatchMetricMode batchMetricMode) {
        return new JrubyWrappedSynchronousQueueExt(context.runtime, RubyUtil.WRAPPED_SYNCHRONOUS_QUEUE_CLASS, size, batchMetricMode);
    }

    @Override
    protected JRubyAbstractQueueWriteClientExt getWriteClient(ThreadContext context) {
        return JrubyMemoryWriteClientExt.create(this.queue);
    }

    @Override
    protected QueueReadClientBase getReadClient() {
        return JrubyMemoryReadClientExt.create(this.queue, 125, 50, this.batchMetricMode);
    }

    @Override
    public IRubyObject doClose(ThreadContext context) {
        return this;
    }
}

