/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public interface EscapeHandler {
    public static final EscapeHandler NONE = new EscapeHandler(){

        @Override
        public String unescape(String escaped) {
            return escaped;
        }

        @Override
        public String escape(String unescaped) {
            return unescaped;
        }
    };
    public static final EscapeHandler PERCENT = new EscapeHandler(){
        private final Pattern ESCAPE_REQUIRED_PERCENT_LITERAL = Pattern.compile("%(?=[0-9A-F]{2})");
        private final Pattern PERCENT_ENCODED_SEQUENCE = Pattern.compile("%[0-9A-F]{2}");
        private final Pattern UNESCAPED_PERCENT_LITERAL = Pattern.compile("%(?![0-9A-F]{2})");

        @Override
        public String escape(String unescaped) {
            return this.ESCAPE_REQUIRED_PERCENT_LITERAL.matcher(unescaped).replaceAll("%25").replace("[", "%5B").replace("]", "%5D");
        }

        @Override
        public String unescape(String escaped) {
            if (!escaped.contains("%")) {
                return escaped;
            }
            if (!this.PERCENT_ENCODED_SEQUENCE.matcher(escaped).find()) {
                return escaped;
            }
            escaped = this.UNESCAPED_PERCENT_LITERAL.matcher(escaped).replaceAll("%25");
            return URLDecoder.decode(escaped, StandardCharsets.UTF_8);
        }
    };
    public static final EscapeHandler AMPERSAND = new EscapeHandler(){
        private final Pattern AMPERSAND_ENCODED_SEQUENCE = Pattern.compile("&#([0-9]{2,});");

        @Override
        public String escape(String unescaped) {
            return unescaped.replaceAll(this.AMPERSAND_ENCODED_SEQUENCE.pattern(), "&#38;#$1;").replace("[", "&#91;").replace("]", "&#93;");
        }

        @Override
        public String unescape(String escaped) {
            if (!escaped.contains("&")) {
                return escaped;
            }
            return this.AMPERSAND_ENCODED_SEQUENCE.matcher(escaped).replaceAll(matchResult -> {
                int codePoint = Integer.parseInt(matchResult.group(1));
                char[] chars = Character.toChars(codePoint);
                return String.copyValueOf(chars);
            });
        }
    };

    public String unescape(String var1);

    public String escape(String var1);
}

