/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

public class IntegratedFunctionCall
extends FunctionCall
implements Callable {
    private ExtensionFunctionCall function;
    private SequenceType resultType = SequenceType.ANY_SEQUENCE;
    private int state = 0;

    public IntegratedFunctionCall(ExtensionFunctionCall function) {
        this.function = function;
    }

    public ExtensionFunctionCall getFunction() {
        return this.function;
    }

    public Container getContainer() {
        return this.function.getContainer();
    }

    public void setContainer(Container container) {
        super.setContainer(this.function.getContainer());
        this.function.setDefinition(this.function.getDefinition(), container);
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        this.checkArgumentCount(definition.getMinimumNumberOfArguments(), definition.getMaximumNumberOfArguments());
        int args = this.getNumberOfArguments();
        SequenceType[] declaredArgumentTypes = definition.getArgumentTypes();
        if (declaredArgumentTypes == null || args != 0 && declaredArgumentTypes.length == 0) {
            throw new XPathException("Integrated function " + this.getDisplayName() + " failed to declare its argument types");
        }
        SequenceType[] actualArgumentTypes = new SequenceType[args];
        for (int i = 0; i < args; ++i) {
            this.argument[i] = TypeChecker.staticTypeCheck(this.argument[i], i < declaredArgumentTypes.length ? declaredArgumentTypes[i] : declaredArgumentTypes[declaredArgumentTypes.length - 1], false, new RoleLocator(0, this.getFunctionName(), i), visitor);
            actualArgumentTypes[i] = SequenceType.makeSequenceType(this.argument[i].getItemType(), this.argument[i].getCardinality());
        }
        this.resultType = definition.getResultType(actualArgumentTypes);
        if (this.state == 0) {
            this.function.supplyStaticContext(visitor.getStaticContext(), 0, this.getArguments());
        }
        ++this.state;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression exp = super.typeCheck(visitor, contextInfo);
        if (exp instanceof IntegratedFunctionCall) {
            Expression exp2 = ((IntegratedFunctionCall)exp).function.rewrite(visitor.getStaticContext(), this.argument);
            if (exp2 == null) {
                return exp;
            }
            ExpressionTool.copyLocationInfo(this, exp2);
            return exp2.simplify(visitor).typeCheck(visitor, contextInfo).optimize(visitor, contextInfo);
        }
        return exp;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public ItemType getItemType() {
        return this.resultType.getPrimaryType();
    }

    protected int computeCardinality() {
        return this.resultType.getCardinality();
    }

    public int getIntrinsicDependencies() {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        return definition.dependsOnFocus() ? 30 : 0;
    }

    protected int computeSpecialProperties() {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        return definition.hasSideEffects() ? 0x1000000 : 0x400000;
    }

    public Expression copy() {
        ExtensionFunctionCall newCall = this.function.getDefinition().makeCallExpression();
        newCall.setDefinition(this.function.getDefinition(), this.function.getContainer());
        this.function.copyLocalData(newCall);
        IntegratedFunctionCall copy = new IntegratedFunctionCall(newCall);
        Expression[] args = new Expression[this.getNumberOfArguments()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.argument[i].copy();
        }
        copy.setFunctionName(this.getFunctionName());
        copy.setArguments(args);
        copy.resultType = this.resultType;
        copy.state = this.state;
        return copy;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ItemMappingIterator result;
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        Sequence[] argValues = new Sequence[this.getNumberOfArguments()];
        for (int i = 0; i < argValues.length; ++i) {
            argValues[i] = SequenceTool.toLazySequence(this.argument[i].iterate(context));
        }
        RoleLocator role = new RoleLocator(5, this.getFunctionName().getDisplayName(), 0);
        final Configuration config = context.getConfiguration();
        try {
            result = this.function.call(context, argValues).iterate();
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
        if (!definition.trustResultType()) {
            ItemType type;
            int card = this.resultType.getCardinality();
            if (card != 57344) {
                result = new CardinalityCheckingIterator(result, card, role, this);
            }
            if ((type = this.resultType.getPrimaryType()) != AnyItemType.getInstance()) {
                result = new ItemMappingIterator(result, new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (!type.matchesItem(item, false, config)) {
                            String msg = "Item returned by integrated function " + IntegratedFunctionCall.this.getFunctionName().getDisplayName() + "() is not of declared item type. Actual type is " + Type.getItemType(item, config.getTypeHierarchy()).toString() + "; expected type is " + type.toString();
                            XPathException err = new XPathException(msg);
                            err.setErrorCode("XPTY0004");
                            err.setLocator(IntegratedFunctionCall.this);
                            throw err;
                        }
                        return item;
                    }
                }, true);
            }
        }
        return result;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Sequence[] argValues = new Sequence[this.getNumberOfArguments()];
        for (int i = 0; i < argValues.length; ++i) {
            argValues[i] = SequenceTool.toLazySequence(this.argument[i].iterate(context));
        }
        try {
            return this.function.effectiveBooleanValue(context, argValues);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.function.call(context, arguments);
    }
}

