/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.types.BaseTypeIdImpl;

public class DecimalTypeIdImpl
extends BaseTypeIdImpl {
    public DecimalTypeIdImpl() {
    }

    public DecimalTypeIdImpl(boolean isNumeric) {
        super(198);
        if (isNumeric) {
            this.setNumericType();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isNumeric = in.readBoolean();
        super.readExternal(in);
        if (isNumeric) {
            this.setNumericType();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.getJDBCTypeId() == 2);
        super.writeExternal(out);
    }

    private void setNumericType() {
        this.unqualifiedName = "NUMERIC";
        this.JDBCTypeId = 2;
    }
}

