/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;

public final class UserDescriptor
extends TupleDescriptor {
    private String _userName;
    private String _hashingScheme;
    private char[] _password;
    private Timestamp _lastModified;

    UserDescriptor(DataDictionary dataDictionary, String userName, String hashingScheme, char[] password, Timestamp lastModified) {
        super(dataDictionary);
        this._userName = userName;
        this._hashingScheme = hashingScheme;
        if (password == null) {
            this._password = null;
        } else {
            this._password = new char[password.length];
            System.arraycopy(password, 0, this._password, 0, password.length);
        }
        this._lastModified = DataTypeUtilities.clone(lastModified);
    }

    public String getUserName() {
        return this._userName;
    }

    public String getHashingScheme() {
        return this._hashingScheme;
    }

    public Timestamp getLastModified() {
        return DataTypeUtilities.clone(this._lastModified);
    }

    public char[] getAndZeroPassword() {
        int length = this._password.length;
        char[] retval = new char[length];
        System.arraycopy(this._password, 0, retval, 0, length);
        Arrays.fill(this._password, '\u0000');
        return retval;
    }

    @Override
    public String getDescriptorType() {
        return "User";
    }

    @Override
    public String getDescriptorName() {
        return this._userName;
    }
}

