/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSemaphoreWaitInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SEMAPHORECOUNT;
    public static final int PSEMAPHORES;
    public static final int PVALUES;

    public VkSemaphoreWaitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSemaphoreWaitInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSemaphoreWaitInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSemaphoreWaitInfo.npNext(this.address());
    }

    @NativeType(value="VkSemaphoreWaitFlags")
    public int flags() {
        return VkSemaphoreWaitInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int semaphoreCount() {
        return VkSemaphoreWaitInfo.nsemaphoreCount(this.address());
    }

    @NativeType(value="VkSemaphore const *")
    public LongBuffer pSemaphores() {
        return VkSemaphoreWaitInfo.npSemaphores(this.address());
    }

    @NativeType(value="uint64_t const *")
    public LongBuffer pValues() {
        return VkSemaphoreWaitInfo.npValues(this.address());
    }

    public VkSemaphoreWaitInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSemaphoreWaitInfo.nsType(this.address(), value);
        return this;
    }

    public VkSemaphoreWaitInfo sType$Default() {
        return this.sType(1000207004);
    }

    public VkSemaphoreWaitInfo pNext(@NativeType(value="void const *") long value) {
        VkSemaphoreWaitInfo.npNext(this.address(), value);
        return this;
    }

    public VkSemaphoreWaitInfo flags(@NativeType(value="VkSemaphoreWaitFlags") int value) {
        VkSemaphoreWaitInfo.nflags(this.address(), value);
        return this;
    }

    public VkSemaphoreWaitInfo semaphoreCount(@NativeType(value="uint32_t") int value) {
        VkSemaphoreWaitInfo.nsemaphoreCount(this.address(), value);
        return this;
    }

    public VkSemaphoreWaitInfo pSemaphores(@NativeType(value="VkSemaphore const *") LongBuffer value) {
        VkSemaphoreWaitInfo.npSemaphores(this.address(), value);
        return this;
    }

    public VkSemaphoreWaitInfo pValues(@NativeType(value="uint64_t const *") LongBuffer value) {
        VkSemaphoreWaitInfo.npValues(this.address(), value);
        return this;
    }

    public VkSemaphoreWaitInfo set(int sType, long pNext, int flags, int semaphoreCount, LongBuffer pSemaphores, LongBuffer pValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.semaphoreCount(semaphoreCount);
        this.pSemaphores(pSemaphores);
        this.pValues(pValues);
        return this;
    }

    public VkSemaphoreWaitInfo set(VkSemaphoreWaitInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSemaphoreWaitInfo malloc() {
        return (VkSemaphoreWaitInfo)VkSemaphoreWaitInfo.wrap(VkSemaphoreWaitInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSemaphoreWaitInfo calloc() {
        return (VkSemaphoreWaitInfo)VkSemaphoreWaitInfo.wrap(VkSemaphoreWaitInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSemaphoreWaitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSemaphoreWaitInfo)VkSemaphoreWaitInfo.wrap(VkSemaphoreWaitInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSemaphoreWaitInfo create(long address) {
        return (VkSemaphoreWaitInfo)VkSemaphoreWaitInfo.wrap(VkSemaphoreWaitInfo.class, (long)address);
    }

    @Nullable
    public static VkSemaphoreWaitInfo createSafe(long address) {
        return address == 0L ? null : (VkSemaphoreWaitInfo)VkSemaphoreWaitInfo.wrap(VkSemaphoreWaitInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSemaphoreWaitInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSemaphoreWaitInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSemaphoreWaitInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSemaphoreWaitInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSemaphoreWaitInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSemaphoreWaitInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSemaphoreWaitInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSemaphoreWaitInfo malloc(MemoryStack stack) {
        return (VkSemaphoreWaitInfo)VkSemaphoreWaitInfo.wrap(VkSemaphoreWaitInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSemaphoreWaitInfo calloc(MemoryStack stack) {
        return (VkSemaphoreWaitInfo)VkSemaphoreWaitInfo.wrap(VkSemaphoreWaitInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkSemaphoreWaitInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkSemaphoreWaitInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nsemaphoreCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SEMAPHORECOUNT);
    }

    public static LongBuffer npSemaphores(long struct) {
        return MemoryUtil.memLongBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PSEMAPHORES)), (int)VkSemaphoreWaitInfo.nsemaphoreCount(struct));
    }

    public static LongBuffer npValues(long struct) {
        return MemoryUtil.memLongBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)), (int)VkSemaphoreWaitInfo.nsemaphoreCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nsemaphoreCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SEMAPHORECOUNT, value);
    }

    public static void npSemaphores(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSEMAPHORES), (long)MemoryUtil.memAddress((LongBuffer)value));
    }

    public static void npValues(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVALUES), (long)MemoryUtil.memAddress((LongBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSEMAPHORES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)));
    }

    static {
        Struct.Layout layout = VkSemaphoreWaitInfo.__struct((Struct.Member[])new Struct.Member[]{VkSemaphoreWaitInfo.__member((int)4), VkSemaphoreWaitInfo.__member((int)POINTER_SIZE), VkSemaphoreWaitInfo.__member((int)4), VkSemaphoreWaitInfo.__member((int)4), VkSemaphoreWaitInfo.__member((int)POINTER_SIZE), VkSemaphoreWaitInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SEMAPHORECOUNT = layout.offsetof(3);
        PSEMAPHORES = layout.offsetof(4);
        PVALUES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkSemaphoreWaitInfo, Buffer>
    implements NativeResource {
        private static final VkSemaphoreWaitInfo ELEMENT_FACTORY = VkSemaphoreWaitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSemaphoreWaitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSemaphoreWaitInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSemaphoreWaitInfo.npNext(this.address());
        }

        @NativeType(value="VkSemaphoreWaitFlags")
        public int flags() {
            return VkSemaphoreWaitInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int semaphoreCount() {
            return VkSemaphoreWaitInfo.nsemaphoreCount(this.address());
        }

        @NativeType(value="VkSemaphore const *")
        public LongBuffer pSemaphores() {
            return VkSemaphoreWaitInfo.npSemaphores(this.address());
        }

        @NativeType(value="uint64_t const *")
        public LongBuffer pValues() {
            return VkSemaphoreWaitInfo.npValues(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSemaphoreWaitInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000207004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSemaphoreWaitInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSemaphoreWaitFlags") int value) {
            VkSemaphoreWaitInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer semaphoreCount(@NativeType(value="uint32_t") int value) {
            VkSemaphoreWaitInfo.nsemaphoreCount(this.address(), value);
            return this;
        }

        public Buffer pSemaphores(@NativeType(value="VkSemaphore const *") LongBuffer value) {
            VkSemaphoreWaitInfo.npSemaphores(this.address(), value);
            return this;
        }

        public Buffer pValues(@NativeType(value="uint64_t const *") LongBuffer value) {
            VkSemaphoreWaitInfo.npValues(this.address(), value);
            return this;
        }
    }
}

