/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.blocking;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FauxAsyncContext {
    private static final long TIME_TO_WAIT = 15000L;
    private Long timeout;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private volatile boolean isRunning;
    private boolean isCompleted;

    public FauxAsyncContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.timeout = 15000L;
    }

    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.timeout = timeout;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        FauxAsyncContext fauxAsyncContext = this;
        synchronized (fauxAsyncContext) {
            this.isRunning = false;
            this.notifyAll();
            this.isCompleted = true;
        }
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTimeoutOrCompletion() {
        FauxAsyncContext fauxAsyncContext = this;
        synchronized (fauxAsyncContext) {
            long totalTimeout;
            if (this.isCompleted) {
                return;
            }
            this.isRunning = true;
            long l = totalTimeout = this.timeout != null ? this.timeout : Long.MAX_VALUE;
            while (this.isRunning) {
                long timeToWait = Math.min(totalTimeout, 15000L);
                try {
                    this.wait(timeToWait);
                }
                catch (InterruptedException e) {
                    this.isRunning = false;
                    return;
                }
                if ((totalTimeout -= timeToWait) > 0L) continue;
                this.isRunning = false;
                return;
            }
        }
    }
}

