"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fillTextColor = void 0;
var chroma_js_1 = __importDefault(require("chroma-js"));
var logger_1 = require("../utils/logger");
var color_calcs_1 = require("./color_calcs");
function isBackgroundColorValid(color, logWarning) {
    var bgColorAlpha = color_calcs_1.isColorValid(color) ? chroma_js_1.default(color).alpha() : 1;
    if (color_calcs_1.isColorValid(color) && bgColorAlpha >= 1) {
        return true;
    }
    if (logWarning && bgColorAlpha < 1) {
        logger_1.Logger.expected('Text contrast requires a background color with an alpha value of 1', 1, bgColorAlpha);
    }
    if (logWarning && color !== 'transparent') {
        logger_1.Logger.warn("Invalid background color \"" + String(color) + "\"");
    }
    return false;
}
function fillTextColor(textColor, textInvertible, textContrast, shapeFillColor, backgroundColor) {
    if (!isBackgroundColorValid(backgroundColor, true)) {
        return color_calcs_1.getTextColorIfTextInvertible(color_calcs_1.colorIsDark(shapeFillColor), color_calcs_1.colorIsDark(textColor), textColor, false, 'white');
    }
    var adjustedTextColor = textColor;
    var containerBackground = color_calcs_1.combineColors(shapeFillColor, backgroundColor);
    var textShouldBeInvertedAndTextContrastIsFalse = textInvertible && !textContrast;
    var textShouldBeInvertedAndTextContrastIsSetToTrue = textInvertible && typeof textContrast !== 'number';
    var textContrastIsSetToANumberValue = typeof textContrast === 'number';
    var textShouldNotBeInvertedButTextContrastIsDefined = textContrast && !textInvertible;
    if (textShouldBeInvertedAndTextContrastIsFalse || textShouldBeInvertedAndTextContrastIsSetToTrue) {
        var backgroundIsDark = color_calcs_1.colorIsDark(color_calcs_1.combineColors(shapeFillColor, backgroundColor));
        var specifiedTextColorIsDark = color_calcs_1.colorIsDark(textColor);
        return color_calcs_1.getTextColorIfTextInvertible(backgroundIsDark, specifiedTextColorIsDark, textColor, textContrast, containerBackground);
    }
    if (textContrastIsSetToANumberValue || textShouldNotBeInvertedButTextContrastIsDefined) {
        return color_calcs_1.makeHighContrastColor(adjustedTextColor, containerBackground);
    }
    return adjustedTextColor;
}
exports.fillTextColor = fillTextColor;
//# sourceMappingURL=fill_text_color.js.map