"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserMessageSchema = exports.ToolSchema = exports.ToolMessageSchema = exports.ToolCallSchema = exports.SystemMessageSchema = exports.StateSchema = exports.RunAgentInputSchema = exports.RoleSchema = exports.MessageSchema = exports.FunctionCallSchema = exports.DeveloperMessageSchema = exports.ContextSchema = exports.BaseMessageSchema = exports.AssistantMessageSchema = exports.AGUIError = void 0;
var _zod = require("zod");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Import interface types from core - these define the structure

// Zod schemas for runtime validation - these ensure the core types are followed
const FunctionCallSchema = exports.FunctionCallSchema = _zod.z.object({
  name: _zod.z.string(),
  arguments: _zod.z.string()
});
const ToolCallSchema = exports.ToolCallSchema = _zod.z.object({
  id: _zod.z.string(),
  type: _zod.z.literal('function'),
  function: FunctionCallSchema
});
const BaseMessageSchema = exports.BaseMessageSchema = _zod.z.object({
  id: _zod.z.string(),
  role: _zod.z.string(),
  content: _zod.z.string().optional(),
  name: _zod.z.string().optional()
});
const DeveloperMessageSchema = exports.DeveloperMessageSchema = BaseMessageSchema.extend({
  role: _zod.z.literal('developer'),
  content: _zod.z.string()
});
const SystemMessageSchema = exports.SystemMessageSchema = BaseMessageSchema.extend({
  role: _zod.z.literal('system'),
  content: _zod.z.string()
});
const AssistantMessageSchema = exports.AssistantMessageSchema = BaseMessageSchema.extend({
  role: _zod.z.literal('assistant'),
  content: _zod.z.string().optional(),
  toolCalls: _zod.z.array(ToolCallSchema).optional()
});
const UserMessageSchema = exports.UserMessageSchema = BaseMessageSchema.extend({
  role: _zod.z.literal('user'),
  content: _zod.z.string()
});
const ToolMessageSchema = exports.ToolMessageSchema = _zod.z.object({
  id: _zod.z.string(),
  content: _zod.z.string(),
  role: _zod.z.literal('tool'),
  toolCallId: _zod.z.string(),
  error: _zod.z.string().optional()
});
const MessageSchema = exports.MessageSchema = _zod.z.discriminatedUnion('role', [DeveloperMessageSchema, SystemMessageSchema, AssistantMessageSchema, UserMessageSchema, ToolMessageSchema]);
const RoleSchema = exports.RoleSchema = _zod.z.union([_zod.z.literal('developer'), _zod.z.literal('system'), _zod.z.literal('assistant'), _zod.z.literal('user'), _zod.z.literal('tool')]);
const ContextSchema = exports.ContextSchema = _zod.z.object({
  description: _zod.z.string(),
  value: _zod.z.string()
});
const ToolSchema = exports.ToolSchema = _zod.z.object({
  name: _zod.z.string(),
  description: _zod.z.string(),
  parameters: _zod.z.any() // JSON Schema for the tool parameters
});

const RunAgentInputSchema = exports.RunAgentInputSchema = _zod.z.object({
  threadId: _zod.z.string(),
  runId: _zod.z.string(),
  state: _zod.z.any(),
  messages: _zod.z.array(MessageSchema),
  tools: _zod.z.array(ToolSchema),
  context: _zod.z.array(ContextSchema),
  forwardedProps: _zod.z.any()
});
const StateSchema = exports.StateSchema = _zod.z.any();

// Business logic types - stay in plugin

class AGUIError extends Error {
  constructor(message) {
    super(message);
  }
}
exports.AGUIError = AGUIError;