/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.Objects;

public abstract class ParameterValue {
    public static Explicit of(String value) {
        return new Explicit(value);
    }

    public static InAppDefault inAppDefault() {
        return new InAppDefault();
    }

    abstract TemplateResponse.ParameterValueResponse toParameterValueResponse();

    static ParameterValue fromParameterValueResponse(@NonNull TemplateResponse.ParameterValueResponse parameterValueResponse) {
        Preconditions.checkNotNull((Object)parameterValueResponse);
        if (parameterValueResponse.isUseInAppDefault()) {
            return ParameterValue.inAppDefault();
        }
        return ParameterValue.of(parameterValueResponse.getValue());
    }

    public static final class InAppDefault
    extends ParameterValue {
        @Override
        TemplateResponse.ParameterValueResponse toParameterValueResponse() {
            return new TemplateResponse.ParameterValueResponse().setUseInAppDefault(true);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static final class Explicit
    extends ParameterValue {
        private final String value;

        private Explicit(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        TemplateResponse.ParameterValueResponse toParameterValueResponse() {
            return new TemplateResponse.ParameterValueResponse().setValue(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Explicit explicit = (Explicit)o;
            return Objects.equals(this.value, explicit.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

