/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import org.parosproxy.paros.security.SslCertificateService;

@Deprecated
public class SslCertificateUtils {
    public static final String BEGIN_CERTIFICATE_TOKEN = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE_TOKEN = "-----END CERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY_TOKEN = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY_TOKEN = "-----END PRIVATE KEY-----";
    private static final long DEFAULT_VALIDITY_IN_MS = Duration.ofDays(365L).toMillis();

    public static final KeyStore createRootCA() throws NoSuchAlgorithmException {
        throw new IllegalStateException("No longer supported.");
    }

    public static final String keyStore2String(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        keystore.store(baos, SslCertificateService.PASSPHRASE);
        byte[] bytes = baos.toByteArray();
        baos.close();
        return Base64.getUrlEncoder().encodeToString(bytes);
    }

    public static final KeyStore string2Keystore(String str) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        byte[] bytes = Base64.getUrlDecoder().decode(str);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(bais, SslCertificateService.PASSPHRASE);
        bais.close();
        return ks;
    }

    public static KeyStore pem2Keystore(File pemFile) throws IOException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, KeyStoreException {
        String certAndKey = FileUtils.readFileToString((File)pemFile, (Charset)StandardCharsets.US_ASCII);
        byte[] certBytes = SslCertificateUtils.extractCertificate(certAndKey);
        byte[] keyBytes = SslCertificateUtils.extractPrivateKey(certAndKey);
        return SslCertificateUtils.pem2KeyStore(certBytes, keyBytes);
    }

    public static byte[] extractCertificate(String pem) {
        return SslCertificateUtils.parseDERFromPEM(pem, BEGIN_CERTIFICATE_TOKEN, END_CERTIFICATE_TOKEN);
    }

    public static byte[] extractPrivateKey(String pem) {
        return SslCertificateUtils.parseDERFromPEM(pem, BEGIN_PRIVATE_KEY_TOKEN, END_PRIVATE_KEY_TOKEN);
    }

    private static boolean containsSection(String contents, String beginToken, String endToken) {
        int idxToken = contents.indexOf(beginToken);
        return idxToken != -1 && contents.indexOf(endToken) >= idxToken;
    }

    public static KeyStore pem2KeyStore(byte[] certBytes, byte[] keyBytes) throws IOException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, KeyStoreException {
        X509Certificate cert = SslCertificateUtils.generateCertificateFromDER(certBytes);
        RSAPrivateKey key = SslCertificateUtils.generatePrivateKeyFromDER(keyBytes);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", cert);
        keystore.setKeyEntry("owasp_zap_root_ca", key, SslCertificateService.PASSPHRASE, new Certificate[]{cert});
        return keystore;
    }

    private static byte[] parseDERFromPEM(String pem, String beginDelimiter, String endDelimiter) {
        if (!SslCertificateUtils.containsSection(pem, beginDelimiter, endDelimiter)) {
            return new byte[0];
        }
        String[] tokens = pem.split(beginDelimiter);
        tokens = tokens[1].split(endDelimiter);
        return Base64.getMimeDecoder().decode(tokens[0]);
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    private static X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }
}

