/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbbulkloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.monetdbbulkloader.Messages;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderData;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderMeta;

public class MonetDBBulkLoader
extends BaseStep
implements StepInterface {
    private MonetDBBulkLoaderMeta meta;
    private MonetDBBulkLoaderData data;

    public MonetDBBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public String createCommandLine(MonetDBBulkLoaderMeta meta, boolean password) throws KettleException {
        DatabaseMeta dm;
        FileObject fileObject;
        StringBuffer sb = new StringBuffer(300);
        if (!Const.isEmpty((String)meta.getMClientPath())) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getMClientPath()));
                String psqlexec = KettleVFS.getFilename((FileObject)fileObject);
                sb.append(psqlexec);
            }
            catch (IOException ex) {
                throw new KettleException("Error retrieving mclient application string", (Throwable)ex);
            }
        } else {
            throw new KettleException("No mclient application specified");
        }
        sb.append(" -lsql");
        if (!Const.isEmpty((String)meta.getEncoding())) {
            sb.append(" --encoding=");
            sb.append(this.environmentSubstitute(meta.getEncoding()));
        }
        if (!Const.isEmpty((String)meta.getLogFile())) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getLogFile()));
                sb.append(" --log=");
                sb.append('\'').append(KettleVFS.getFilename((FileObject)fileObject)).append('\'');
            }
            catch (IOException ex) {
                throw new KettleException("Error retrieving logfile string", (Throwable)ex);
            }
        }
        if ((dm = meta.getDatabaseMeta()) != null) {
            String user = this.environmentSubstitute(Const.NVL((String)dm.getUsername(), (String)""));
            String pass = this.environmentSubstitute(Const.NVL((String)dm.getPassword(), (String)""));
            String hostname = this.environmentSubstitute(Const.NVL((String)dm.getHostname(), (String)""));
            String portnum = this.environmentSubstitute(Const.NVL((String)dm.getDatabasePortNumberString(), (String)""));
            String dbname = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseName(), (String)""));
            if (!Const.isEmpty((String)user)) {
                sb.append(" --user=").append(user);
            }
            if (!Const.isEmpty((String)pass)) {
                sb.append(" --passwd=");
                if (password) {
                    sb.append(pass);
                } else {
                    sb.append("******");
                }
            }
            if (!Const.isEmpty((String)hostname)) {
                sb.append(" --host=").append(hostname);
            }
            if (!Const.isEmpty((String)portnum) && Const.toInt((String)portnum, (int)-1) > 0) {
                sb.append(" --port=").append(portnum);
            }
            if (!Const.isEmpty((String)dbname)) {
                sb.append(" --database=").append(dbname);
            }
        } else {
            throw new KettleException("No connection specified");
        }
        return sb.toString();
    }

    public boolean execute(MonetDBBulkLoaderMeta meta, boolean wait) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            String cmd = this.createCommandLine(meta, true);
            this.logBasic("Executing command: " + cmd);
            this.data.mClientlProcess = rt.exec(cmd);
            this.data.errorLogger = new StreamLogger(this.data.mClientlProcess.getErrorStream(), "ERROR");
            this.data.outputLogger = new StreamLogger(this.data.mClientlProcess.getInputStream(), "OUTPUT");
            this.data.monetOutputStream = this.data.mClientlProcess.getOutputStream();
            new Thread((Runnable)this.data.errorLogger).start();
            new Thread((Runnable)this.data.outputLogger).start();
        }
        catch (Exception ex) {
            throw new KettleException("Error while executing mclient : " + this.createCommandLine(meta, false), (Throwable)ex);
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                this.data.monetOutputStream.flush();
                this.data.monetOutputStream.close();
                int exitVal = this.data.mClientlProcess.waitFor();
                this.logBasic(Messages.getString("MonetDBBulkLoader.Log.ExitValuePsqlPath", "" + exitVal));
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.execute(this.meta, true);
            }
            this.writeRowToMonetDB(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(Messages.getString("MonetDBBulkLoader.Log.ErrorInStep"), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void writeRowToMonetDB(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        if (this.data.bufferIndex < this.data.bufferSize) {
            this.addRowToBuffer(rowMeta, r);
        } else {
            this.writeBufferToMonetDB();
        }
    }

    private void addRowToBuffer(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        ByteArrayOutputStream line = new ByteArrayOutputStream(25000);
        try {
            block10: for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    line.write(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) continue;
                switch (valueMeta.getType()) {
                    case 2: {
                        line.write(this.data.quote);
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            line.write((byte[])valueData);
                        } else {
                            line.write(valueMeta.getString(valueData).getBytes());
                        }
                        line.write(this.data.quote);
                        continue block10;
                    }
                    case 5: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            line.write((byte[])valueData);
                            continue block10;
                        }
                        line.write(Long.toString(valueMeta.getInteger(valueData)).getBytes());
                        continue block10;
                    }
                    case 3: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            line.write((byte[])valueData);
                            continue block10;
                        }
                        Date date = valueMeta.getDate(valueData);
                        line.write(this.data.monetDateMeta.getString((Object)date).getBytes());
                        continue block10;
                    }
                    case 4: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            line.write((byte[])valueData);
                            continue block10;
                        }
                        line.write(Boolean.toString(valueMeta.getBoolean(valueData)).getBytes());
                        continue block10;
                    }
                    case 1: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            line.write((byte[])valueData);
                            continue block10;
                        }
                        line.write(Double.toString(valueMeta.getNumber(valueData)).getBytes());
                        continue block10;
                    }
                    case 6: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            line.write((byte[])valueData);
                            continue block10;
                        }
                        line.write(valueMeta.getString(valueData).getBytes());
                    }
                }
            }
            line.write(this.data.newline);
            this.data.rowBuffer[this.data.bufferIndex] = line.toByteArray();
            ++this.data.bufferIndex;
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the psql command", (Throwable)e);
        }
    }

    private void writeBufferToMonetDB() throws KettleException {
        if (this.data.bufferIndex == 0) {
            return;
        }
        try {
            String cmd = "COPY " + this.data.bufferIndex + " RECORDS INTO " + this.data.schemaTable + " FROM STDIN;";
            if (this.log.isDetailed()) {
                this.logDetailed(cmd);
            }
            this.data.monetOutputStream.write(cmd.getBytes());
            for (int i = 0; i < this.data.bufferIndex; ++i) {
                this.data.monetOutputStream.write(this.data.rowBuffer[i]);
                if (!this.log.isRowLevel()) continue;
                this.logRowlevel(new String(this.data.rowBuffer[i]));
            }
            this.data.monetOutputStream.write(Const.CR.getBytes());
            if (this.log.isRowLevel()) {
                this.logRowlevel(Const.CR);
            }
            this.data.bufferIndex = 0;
        }
        catch (Exception e) {
            throw new KettleException("An error occurred writing data to the mclient process", (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        if (super.init(smi, sdi)) {
            this.data.quote = "\"".getBytes();
            this.data.separator = "|".getBytes();
            this.data.newline = Const.CR.getBytes();
            this.data.monetDateMeta = new ValueMeta("dateMeta", 3);
            this.data.monetDateMeta.setConversionMask("yyyy/MM/dd HH:mm:ss");
            this.data.monetDateMeta.setStringEncoding(this.meta.getEncoding());
            this.data.monetNumberMeta = new ValueMeta("numberMeta", 1);
            this.data.monetNumberMeta.setConversionMask("#.#");
            this.data.monetNumberMeta.setGroupingSymbol(",");
            this.data.monetNumberMeta.setDecimalSymbol(".");
            this.data.monetNumberMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bufferSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBufferSize()), (int)100000);
            this.data.rowBuffer = new byte[this.data.bufferSize][];
            this.data.bufferIndex = 0;
            this.data.schemaTable = this.meta.getDatabaseMeta().getSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        try {
            this.data.monetOutputStream.close();
            int exitValue = this.data.mClientlProcess.waitFor();
            this.logDetailed("Exit value for the mclient process was : " + exitValue);
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while finishing the mclient process", e);
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

