/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonValueFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class MySQLJsonValueFunction
extends JsonValueFunction {
    public MySQLJsonValueFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonValueErrorBehavior.ERROR || arguments.emptyBehavior() == JsonValueEmptyBehavior.ERROR || arguments.emptyBehavior() != null && arguments.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
            super.render(sqlAppender, arguments, returnType, walker);
        } else {
            if (arguments.returningType() != null) {
                if (arguments.returningType().getJdbcMapping().getJdbcType().isBoolean()) {
                    sqlAppender.append("case ");
                } else {
                    sqlAppender.append("cast(");
                }
            }
            sqlAppender.appendSql("json_unquote(nullif(json_extract(");
            arguments.jsonDocument().accept(walker);
            sqlAppender.appendSql(",");
            JsonPathPassingClause passingClause = arguments.passingClause();
            if (passingClause == null) {
                arguments.jsonPath().accept(walker);
            } else {
                JsonPathHelper.appendJsonPathConcatPassingClause(sqlAppender, arguments.jsonPath(), passingClause, walker);
            }
            sqlAppender.appendSql("),cast('null' as json)))");
            if (arguments.returningType() != null) {
                if (arguments.returningType().getJdbcMapping().getJdbcType().isBoolean()) {
                    sqlAppender.append(" when 'true' then true when 'false' then false end ");
                } else {
                    sqlAppender.appendSql(" as ");
                    arguments.returningType().accept(walker);
                    sqlAppender.appendSql(')');
                }
            }
        }
    }
}

