/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.apache.karaf.jaas.modules.ldap.LDAPCache;
import org.apache.karaf.jaas.modules.ldap.LDAPLoginModule;
import org.apache.karaf.jaas.modules.ldap.LDAPOptions;
import org.apache.karaf.jaas.modules.ldap.ManagedSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSSAPILdapLoginModule
extends AbstractKarafLoginModule {
    private static Logger logger = LoggerFactory.getLogger(LDAPLoginModule.class);
    public static final String REALM_PROPERTY = "gssapiRealm";
    private LoginContext context;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
    }

    @Override
    public boolean login() throws LoginException {
        if (!this.options.containsKey(REALM_PROPERTY)) {
            logger.warn("gssapiRealm is not set");
            throw new LoginException("cannot authenticate through the delegating realm");
        }
        this.context = new LoginContext(JAASUtils.getString(this.options, REALM_PROPERTY), this.subject, this.callbackHandler);
        this.context.login();
        try {
            this.succeeded = Subject.doAs(this.context.getSubject(), this::doLogin);
            return this.succeeded;
        }
        catch (PrivilegedActionException pExcp) {
            logger.error("error with delegated authentication", (Throwable)pExcp);
            throw new LoginException(pExcp.getMessage());
        }
    }

    protected boolean doLogin() throws LoginException {
        HashMap<String, String> opts = new HashMap<String, String>(this.options);
        opts.put("authentication", "GSSAPI");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            String[] userDnAndNamespace;
            LDAPCache cache;
            block21: {
                LDAPOptions lOptions = new LDAPOptions(opts);
                Callback[] callbacks = new NameCallback[]{new NameCallback("Username: ")};
                try {
                    this.callbackHandler.handle(callbacks);
                }
                catch (IOException ioException) {
                    logger.error("error with callback handler", (Throwable)ioException);
                    throw new LoginException(ioException.getMessage());
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    logger.error("error with callback handler", (Throwable)unsupportedCallbackException);
                    throw new LoginException(unsupportedCallbackException.getMessage() + " not available to obtain information from user.");
                }
                this.user = ((NameCallback)callbacks[0]).getName();
                this.principals = new HashSet();
                cache = LDAPCache.getCache(lOptions);
                try {
                    logger.debug("Get the user DN.");
                    userDnAndNamespace = cache.getUserDnAndNamespace(this.user);
                }
                catch (Exception e) {
                    logger.warn("Can't connect to the LDAP server: {}", (Object)e.getMessage(), (Object)e);
                    throw new LoginException("Can't connect to the LDAP server: " + e.getMessage());
                }
                if (userDnAndNamespace != null) break block21;
                boolean e = false;
                if (cache != null) {
                    cache.close();
                }
                return e;
            }
            try {
                this.principals.add(new UserPrincipal(this.user));
                try {
                    String[] roles;
                    for (String role : roles = cache.getUserRoles(this.user, userDnAndNamespace[0], userDnAndNamespace[1])) {
                        this.principals.add(new RolePrincipal(role));
                    }
                }
                catch (Exception e) {
                    throw new LoginException("Can't get user " + this.user + " roles: " + e.getMessage());
                }
                boolean bl = true;
                if (cache != null) {
                    cache.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (cache != null) {
                    try {
                        cache.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            ManagedSSLSocketFactory.setSocketFactory(null);
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        boolean ret = super.commit();
        if (ret) {
            this.principals.addAll(this.subject.getPrincipals(KerberosPrincipal.class));
        }
        return ret;
    }
}

