"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseDateString = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const parseDateString = dateString => {
  const date = _datemath.default.parse(dateString);
  return date ? date.toDate().toISOString() : new Date().toISOString();
};
exports.parseDateString = parseDateString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfZGF0ZW1hdGgiLCJfaW50ZXJvcFJlcXVpcmVEZWZhdWx0IiwicmVxdWlyZSIsImUiLCJfX2VzTW9kdWxlIiwiZGVmYXVsdCIsInBhcnNlRGF0ZVN0cmluZyIsImRhdGVTdHJpbmciLCJkYXRlIiwiZGF0ZU1hdGgiLCJwYXJzZSIsInRvRGF0ZSIsInRvSVNPU3RyaW5nIiwiRGF0ZSIsImV4cG9ydHMiXSwic291cmNlcyI6WyJEYXRlVXRpbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuaW1wb3J0IGRhdGVNYXRoIGZyb20gJ0BlbGFzdGljL2RhdGVtYXRoJztcblxuZXhwb3J0IGNvbnN0IHBhcnNlRGF0ZVN0cmluZyA9IChkYXRlU3RyaW5nOiBzdHJpbmcpOiBzdHJpbmcgPT4ge1xuICBjb25zdCBkYXRlID0gZGF0ZU1hdGgucGFyc2UoZGF0ZVN0cmluZyk7XG4gIHJldHVybiBkYXRlID8gZGF0ZS50b0RhdGUoKS50b0lTT1N0cmluZygpIDogbmV3IERhdGUoKS50b0lTT1N0cmluZygpO1xufTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBSUEsSUFBQUEsU0FBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBQXlDLFNBQUFELHVCQUFBRSxDQUFBLFdBQUFBLENBQUEsSUFBQUEsQ0FBQSxDQUFBQyxVQUFBLEdBQUFELENBQUEsS0FBQUUsT0FBQSxFQUFBRixDQUFBO0FBSnpDO0FBQ0E7QUFDQTtBQUNBOztBQUdPLE1BQU1HLGVBQWUsR0FBSUMsVUFBa0IsSUFBYTtFQUM3RCxNQUFNQyxJQUFJLEdBQUdDLGlCQUFRLENBQUNDLEtBQUssQ0FBQ0gsVUFBVSxDQUFDO0VBQ3ZDLE9BQU9DLElBQUksR0FBR0EsSUFBSSxDQUFDRyxNQUFNLENBQUMsQ0FBQyxDQUFDQyxXQUFXLENBQUMsQ0FBQyxHQUFHLElBQUlDLElBQUksQ0FBQyxDQUFDLENBQUNELFdBQVcsQ0FBQyxDQUFDO0FBQ3RFLENBQUM7QUFBQ0UsT0FBQSxDQUFBUixlQUFBLEdBQUFBLGVBQUEifQ==