/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.Column;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Filter;
import net.sf.mpxj.Group;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.View;
import net.sf.mpxj.explorer.MpxjTreeNode;
import net.sf.mpxj.explorer.ProjectTreeModel;
import net.sf.mpxj.json.JsonWriter;
import net.sf.mpxj.mpx.MPXWriter;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.planner.PlannerWriter;
import net.sf.mpxj.primavera.PrimaveraPMFileWriter;
import net.sf.mpxj.reader.UniversalProjectReader;
import net.sf.mpxj.sdef.SDEFWriter;
import net.sf.mpxj.writer.ProjectWriter;

public class ProjectTreeController {
    private static final Map<String, Class<? extends ProjectWriter>> WRITER_MAP = new HashMap<String, Class<? extends ProjectWriter>>();
    final SimpleDateFormat m_timeFormat = new SimpleDateFormat("HH:mm");
    final SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Set<String> FILE_EXCLUDED_METHODS;
    private static final Set<String> CALENDAR_EXCLUDED_METHODS;
    private static final Set<String> TASK_EXCLUDED_METHODS;
    private static final Set<String> CALENDAR_EXCEPTION_EXCLUDED_METHODS;
    private static final Set<String> TABLE_EXCLUDED_METHODS;
    private final ProjectTreeModel m_model;
    private ProjectFile m_projectFile;

    public ProjectTreeController(ProjectTreeModel projectTreeModel) {
        this.m_model = projectTreeModel;
    }

    public void loadFile(File file) {
        try {
            this.m_projectFile = new UniversalProjectReader().read(file);
            if (this.m_projectFile == null) {
                throw new IllegalArgumentException("Unsupported file type");
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        MpxjTreeNode mpxjTreeNode = new MpxjTreeNode(this.m_projectFile, FILE_EXCLUDED_METHODS){

            @Override
            public String toString() {
                return "Project";
            }
        };
        MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this.m_projectFile.getProjectConfig()){

            @Override
            public String toString() {
                return "MPXJ Configuration";
            }
        };
        mpxjTreeNode.add(mpxjTreeNode2);
        MpxjTreeNode mpxjTreeNode3 = new MpxjTreeNode(this.m_projectFile.getProjectProperties()){

            @Override
            public String toString() {
                return "Properties";
            }
        };
        mpxjTreeNode.add(mpxjTreeNode3);
        MpxjTreeNode mpxjTreeNode4 = new MpxjTreeNode("Tasks");
        mpxjTreeNode.add(mpxjTreeNode4);
        this.addTasks(mpxjTreeNode4, this.m_projectFile);
        MpxjTreeNode mpxjTreeNode5 = new MpxjTreeNode("Resources");
        mpxjTreeNode.add(mpxjTreeNode5);
        this.addResources(mpxjTreeNode5, this.m_projectFile);
        MpxjTreeNode mpxjTreeNode6 = new MpxjTreeNode("Assignments");
        mpxjTreeNode.add(mpxjTreeNode6);
        this.addAssignments(mpxjTreeNode6, this.m_projectFile);
        MpxjTreeNode mpxjTreeNode7 = new MpxjTreeNode("Calendars");
        mpxjTreeNode.add(mpxjTreeNode7);
        this.addCalendars(mpxjTreeNode7, this.m_projectFile);
        MpxjTreeNode mpxjTreeNode8 = new MpxjTreeNode("Groups");
        mpxjTreeNode.add(mpxjTreeNode8);
        this.addGroups(mpxjTreeNode8, this.m_projectFile);
        MpxjTreeNode mpxjTreeNode9 = new MpxjTreeNode("Custom Fields");
        mpxjTreeNode.add(mpxjTreeNode9);
        this.addCustomFields(mpxjTreeNode9, this.m_projectFile);
        MpxjTreeNode mpxjTreeNode10 = new MpxjTreeNode("Filters");
        mpxjTreeNode.add(mpxjTreeNode10);
        MpxjTreeNode mpxjTreeNode11 = new MpxjTreeNode("Task Filters");
        mpxjTreeNode10.add(mpxjTreeNode11);
        this.addFilters(mpxjTreeNode11, this.m_projectFile.getFilters().getTaskFilters());
        MpxjTreeNode mpxjTreeNode12 = new MpxjTreeNode("Resource Filters");
        mpxjTreeNode10.add(mpxjTreeNode12);
        this.addFilters(mpxjTreeNode12, this.m_projectFile.getFilters().getResourceFilters());
        MpxjTreeNode mpxjTreeNode13 = new MpxjTreeNode("Views");
        mpxjTreeNode.add(mpxjTreeNode13);
        this.addViews(mpxjTreeNode13, this.m_projectFile);
        MpxjTreeNode mpxjTreeNode14 = new MpxjTreeNode("Tables");
        mpxjTreeNode.add(mpxjTreeNode14);
        this.addTables(mpxjTreeNode14, this.m_projectFile);
        this.m_model.setRoot(mpxjTreeNode);
    }

    private void addTasks(MpxjTreeNode mpxjTreeNode, ChildTaskContainer childTaskContainer) {
        Iterator<Task> iterator = childTaskContainer.getChildTasks().iterator();
        while (iterator.hasNext()) {
            Task task;
            final Task task2 = task = iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, task, TASK_EXCLUDED_METHODS){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object, set);
                }

                @Override
                public String toString() {
                    return task2.getName();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
            this.addTasks(mpxjTreeNode2, task);
        }
    }

    private void addResources(MpxjTreeNode mpxjTreeNode, ProjectFile projectFile) {
        Iterator iterator = projectFile.getResources().iterator();
        while (iterator.hasNext()) {
            Resource resource;
            final Resource resource2 = resource = (Resource)iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, resource){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    return resource2.getName();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    private void addCalendars(MpxjTreeNode mpxjTreeNode, ProjectFile projectFile) {
        for (ProjectCalendar projectCalendar : projectFile.getCalendars()) {
            this.addCalendar(mpxjTreeNode, projectCalendar);
        }
    }

    private void addCalendar(MpxjTreeNode mpxjTreeNode, final ProjectCalendar projectCalendar) {
        MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, projectCalendar, CALENDAR_EXCLUDED_METHODS){
            final /* synthetic */ ProjectTreeController this$0;
            {
                this.this$0 = projectTreeController;
                super(object, set);
            }

            @Override
            public String toString() {
                return projectCalendar.getName();
            }
        };
        mpxjTreeNode.add(mpxjTreeNode2);
        MpxjTreeNode mpxjTreeNode3 = new MpxjTreeNode("Days");
        mpxjTreeNode2.add(mpxjTreeNode3);
        for (Day day : Day.values()) {
            this.addCalendarDay(mpxjTreeNode3, projectCalendar, day);
        }
        MpxjTreeNode mpxjTreeNode4 = new MpxjTreeNode("Exceptions");
        mpxjTreeNode2.add(mpxjTreeNode4);
        for (ProjectCalendarException projectCalendarException : projectCalendar.getCalendarExceptions()) {
            this.addCalendarException(mpxjTreeNode4, projectCalendarException);
        }
    }

    private void addCalendarDay(MpxjTreeNode mpxjTreeNode, ProjectCalendar projectCalendar, final Day day) {
        MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, day){
            final /* synthetic */ ProjectTreeController this$0;
            {
                this.this$0 = projectTreeController;
                super(object);
            }

            @Override
            public String toString() {
                return day.name();
            }
        };
        mpxjTreeNode.add(mpxjTreeNode2);
        this.addHours(mpxjTreeNode2, projectCalendar.getHours(day));
    }

    private void addHours(MpxjTreeNode mpxjTreeNode, ProjectCalendarDateRanges projectCalendarDateRanges) {
        Iterator<DateRange> iterator = projectCalendarDateRanges.iterator();
        while (iterator.hasNext()) {
            DateRange dateRange;
            final DateRange dateRange2 = dateRange = iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, dateRange){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    return this.this$0.m_timeFormat.format(dateRange2.getStart()) + " - " + this.this$0.m_timeFormat.format(dateRange2.getEnd());
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    private void addCalendarException(MpxjTreeNode mpxjTreeNode, final ProjectCalendarException projectCalendarException) {
        MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, projectCalendarException, CALENDAR_EXCEPTION_EXCLUDED_METHODS){
            final /* synthetic */ ProjectTreeController this$0;
            {
                this.this$0 = projectTreeController;
                super(object, set);
            }

            @Override
            public String toString() {
                return this.this$0.m_dateFormat.format(projectCalendarException.getFromDate());
            }
        };
        mpxjTreeNode.add(mpxjTreeNode2);
        this.addHours(mpxjTreeNode2, projectCalendarException);
    }

    private void addGroups(MpxjTreeNode mpxjTreeNode, ProjectFile projectFile) {
        Iterator iterator = projectFile.getGroups().iterator();
        while (iterator.hasNext()) {
            Group group;
            final Group group2 = group = (Group)iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, group){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    return group2.getName();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    private void addCustomFields(MpxjTreeNode mpxjTreeNode, ProjectFile projectFile) {
        Iterator<CustomField> iterator = projectFile.getCustomFields().iterator();
        while (iterator.hasNext()) {
            CustomField customField;
            final CustomField customField2 = customField = iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, customField){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    FieldType fieldType = customField2.getFieldType();
                    return fieldType == null ? "(unknown)" : fieldType.toString();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    private void addViews(MpxjTreeNode mpxjTreeNode, ProjectFile projectFile) {
        Iterator iterator = projectFile.getViews().iterator();
        while (iterator.hasNext()) {
            View view;
            final View view2 = view = (View)iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, view){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    return view2.getName();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    private void addTables(MpxjTreeNode mpxjTreeNode, ProjectFile projectFile) {
        Iterator iterator = projectFile.getTables().iterator();
        while (iterator.hasNext()) {
            Table table;
            final Table table2 = table = (Table)iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, table, TABLE_EXCLUDED_METHODS){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object, set);
                }

                @Override
                public String toString() {
                    return table2.getName();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
            this.addColumns(mpxjTreeNode2, table);
        }
    }

    private void addColumns(MpxjTreeNode mpxjTreeNode, Table table) {
        Iterator<Column> iterator = table.getColumns().iterator();
        while (iterator.hasNext()) {
            Column column;
            final Column column2 = column = iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, column){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    return column2.getTitle();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    private void addFilters(MpxjTreeNode mpxjTreeNode, List<Filter> list) {
        Iterator<Filter> iterator = list.iterator();
        while (iterator.hasNext()) {
            Filter filter;
            final Filter filter2 = filter = iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, filter){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    return filter2.getName();
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    private void addAssignments(MpxjTreeNode mpxjTreeNode, ProjectFile projectFile) {
        Iterator iterator = projectFile.getResourceAssignments().iterator();
        while (iterator.hasNext()) {
            ResourceAssignment resourceAssignment;
            final ResourceAssignment resourceAssignment2 = resourceAssignment = (ResourceAssignment)iterator.next();
            MpxjTreeNode mpxjTreeNode2 = new MpxjTreeNode(this, resourceAssignment2){
                final /* synthetic */ ProjectTreeController this$0;
                {
                    this.this$0 = projectTreeController;
                    super(object);
                }

                @Override
                public String toString() {
                    Resource resource = resourceAssignment2.getResource();
                    String string = resource == null ? "(unknown resource)" : resource.getName();
                    Task task = resourceAssignment2.getTask();
                    String string2 = task == null ? "(unknown task)" : task.getName();
                    return string + "->" + string2;
                }
            };
            mpxjTreeNode.add(mpxjTreeNode2);
        }
    }

    public void saveFile(File file, String string) {
        try {
            Class<? extends ProjectWriter> clazz = WRITER_MAP.get(string);
            if (clazz == null) {
                throw new IllegalArgumentException("Cannot write files of type: " + string);
            }
            ProjectWriter projectWriter = clazz.newInstance();
            projectWriter.write(this.m_projectFile, file);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Set<String> excludedMethods(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(MpxjTreeNode.DEFAULT_EXCLUDED_METHODS);
        hashSet.addAll(Arrays.asList(stringArray));
        return hashSet;
    }

    static {
        WRITER_MAP.put("MPX", MPXWriter.class);
        WRITER_MAP.put("MSPDI", MSPDIWriter.class);
        WRITER_MAP.put("PMXML", PrimaveraPMFileWriter.class);
        WRITER_MAP.put("PLANNER", PlannerWriter.class);
        WRITER_MAP.put("JSON", JsonWriter.class);
        WRITER_MAP.put("SDEF", SDEFWriter.class);
        FILE_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getAllResourceAssignments", "getAllResources", "getAllTasks", "getChildTasks", "getCalendars", "getCustomFields", "getEventManager", "getFilters", "getGroups", "getProjectProperties", "getProjectConfig", "getViews", "getTables");
        CALENDAR_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getCalendarExceptions");
        TASK_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getChildTasks", "getEffectiveCalendar", "getParentTask", "getResourceAssignments");
        CALENDAR_EXCEPTION_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getRange");
        TABLE_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getColumns");
    }
}

