/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.features;

import com.intellij.filePrediction.features.history.FileHistoryManagerWrapper;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereSpellCheckResult;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.DoubleEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.local.FileTypeUsageSummary;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProviderKt;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywherePsiElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywherePsiElementFeaturesProviderUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0016JD\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00180\u00182\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J2\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J6\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020#0\"H\u0002J)\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010*J\"\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00052\u0006\u0010-\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u00101\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u00102\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u00103\u001a\u00020\u000eH\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u00066"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereClassOrFileFeaturesProvider;", "Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereElementFeaturesProvider;", "<init>", "()V", "getFeaturesDeclarations", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getElementFeatures", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "correction", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereSpellCheckResult;", "isAccessibleFromModule", "Lcom/intellij/psi/PsiElement;", "openedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingFile", "kotlin.jvm.PlatformType", "item", "getFileFeatures", "file", "project", "Lcom/intellij/openapi/project/Project;", "getFileTypeStats", "fileTypeStats", "", "Lcom/intellij/internal/statistic/local/FileTypeUsageSummary;", "isSameModuleAsOpenedFile", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "calculateRootDistance", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Ljava/lang/Integer;", "isSameFileTypeAsOpenedFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Boolean;", "getFileLocationStats", "getRecentFilesIndex", "virtualFile", "getModificationTimeStats", "getPredictionScore", "", "isOpened", "allInitialLettersMatch", "query", "getElementName", "Fields", "intellij.searchEverywhereMl.ranking.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSearchEverywhereClassOrFileFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereClassOrFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereClassOrFileFeaturesProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,348:1\n1#2:349\n434#3:350\n507#3,5:351\n434#3:356\n507#3,5:357\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereClassOrFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereClassOrFileFeaturesProvider\n*L\n328#1:350\n328#1:351,5\n330#1:356\n330#1:357,5\n*E\n"})
public final class SearchEverywhereClassOrFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    public SearchEverywhereClassOrFileFeaturesProvider() {
        Class[] classArray = new Class[]{ClassSearchEverywhereContributor.class, FileSearchEverywhereContributor.class, RecentFilesSEContributor.class};
        super(classArray);
    }

    @Override
    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        Object[] objectArray = new PrimitiveEventField[]{Fields.INSTANCE.getIS_ACCESSIBLE_FROM_MODULE(), Fields.INSTANCE.getIS_SAME_MODULE_DATA_KEY(), Fields.INSTANCE.getDIRECTORY_DEPTH_DATA_KEY(), Fields.INSTANCE.getIS_SAME_FILETYPE_AS_OPENED_FILE_DATA_KEY(), Fields.INSTANCE.getIS_IN_SOURCE_DATA_KEY(), Fields.INSTANCE.getIS_IN_TEST_SOURCES_DATA_KEY(), Fields.INSTANCE.getIS_IN_LIBRARY_DATA_KEY(), Fields.INSTANCE.getIS_EXCLUDED_DATA_KEY(), Fields.INSTANCE.getFILETYPE_USAGE_RATIO_DATA_KEY(), Fields.INSTANCE.getFILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY(), Fields.INSTANCE.getFILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY(), Fields.INSTANCE.getTIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY(), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_MINUTE_DATA_KEY(), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_HOUR_DATA_KEY(), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_DAY_DATA_KEY(), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_MONTH_DATA_KEY(), Fields.INSTANCE.getRECENT_INDEX_DATA_KEY(), Fields.INSTANCE.getPREDICTION_SCORE_DATA_KEY(), Fields.INSTANCE.getTIME_SINCE_LAST_MODIFICATION_DATA_KEY(), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY(), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_HOUR_DATA_KEY(), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_DAY_DATA_KEY(), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_MONTH_DATA_KEY(), Fields.INSTANCE.getIS_OPENED_DATA_KEY(), Fields.INSTANCE.getALL_INITIAL_LETTERS_MATCH_DATA_KEY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache, @NotNull SearchEverywhereSpellCheckResult correction) {
        List list;
        block3: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
            Intrinsics.checkNotNullParameter((Object)correction, (String)"correction");
            List $this$getElementFeatures_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$getElementFeatures_u24lambda_u240.add(Fields.INSTANCE.getALL_INITIAL_LETTERS_MATCH_DATA_KEY().with((Object)this.allInitialLettersMatch(element, searchQuery)));
            PsiElement psiElement = SearchEverywherePsiElementFeaturesProviderUtils.INSTANCE.getPsiElementOrNull(element);
            if (psiElement == null) break block3;
            PsiElement item = psiElement;
            boolean bl2 = false;
            VirtualFile file = this.getContainingFile(item);
            Project project = (Project)ReadAction.compute(() -> SearchEverywhereClassOrFileFeaturesProvider.getElementFeatures$lambda$0$0$0(item));
            if (project == null) {
                return CollectionsKt.listOf((Object)SearchEverywherePsiElementFeaturesProvider.Fields.getIS_INVALID_DATA_KEY().with((Object)true));
            }
            Project project2 = project;
            if (file != null && cache != null) {
                $this$getElementFeatures_u24lambda_u240.addAll((Collection)this.getFileFeatures(file, project2, cache, currentTime));
            }
            if (!(item instanceof PsiFileSystemItem)) {
                FeaturesProviderCache featuresProviderCache = cache;
                $this$getElementFeatures_u24lambda_u240.addAll((Collection)this.isAccessibleFromModule(item, (VirtualFile)(featuresProviderCache != null ? featuresProviderCache.getCurrentlyOpenedFile() : null)));
            }
        }
        return CollectionsKt.build((List)list);
    }

    private final List<EventPair<?>> isAccessibleFromModule(PsiElement element, VirtualFile openedFile) {
        Object object;
        block3: {
            block2: {
                object = openedFile;
                if (object == null) break block2;
                VirtualFile it = object;
                boolean bl = false;
                List list = (List)ReadAction.compute(() -> SearchEverywhereClassOrFileFeaturesProvider.isAccessibleFromModule$lambda$0$0(element, it));
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final VirtualFile getContainingFile(PsiElement item) {
        return item instanceof PsiFileSystemItem ? ((PsiFileSystemItem)item).getVirtualFile() : (VirtualFile)ReadAction.compute(() -> SearchEverywhereClassOrFileFeaturesProvider.getContainingFile$lambda$0(item));
    }

    private final List<EventPair<?>> getFileFeatures(VirtualFile file, Project project, FeaturesProviderCache cache, long currentTime) {
        List list;
        block0: {
            List $this$getFileFeatures_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$getFileFeatures_u24lambda_u240.addAll((Collection)this.getFileLocationStats(file, project));
            SearchEverywhereElementFeaturesProviderKt.putIfValueNotNull($this$getFileFeatures_u24lambda_u240, (EventField)Fields.INSTANCE.getIS_SAME_FILETYPE_AS_OPENED_FILE_DATA_KEY(), this.isSameFileTypeAsOpenedFile(file, cache.getCurrentlyOpenedFile()));
            SearchEverywhereElementFeaturesProviderKt.putIfValueNotNull($this$getFileFeatures_u24lambda_u240, (EventField)Fields.INSTANCE.getIS_SAME_MODULE_DATA_KEY(), this.isSameModuleAsOpenedFile(file, project, cache.getCurrentlyOpenedFile()));
            $this$getFileFeatures_u24lambda_u240.addAll((Collection)this.getFileTypeStats(file, currentTime, cache.getFileTypeUsageStatistics()));
            $this$getFileFeatures_u24lambda_u240.add(Fields.INSTANCE.getRECENT_INDEX_DATA_KEY().with((Object)this.getRecentFilesIndex(file, project)));
            $this$getFileFeatures_u24lambda_u240.add(Fields.INSTANCE.getPREDICTION_SCORE_DATA_KEY().with((Object)this.getPredictionScore(file, project)));
            $this$getFileFeatures_u24lambda_u240.addAll((Collection)this.getModificationTimeStats(file, currentTime));
            $this$getFileFeatures_u24lambda_u240.add(Fields.INSTANCE.getIS_OPENED_DATA_KEY().with((Object)this.isOpened(file, project)));
            Integer n = this.calculateRootDistance(file, project);
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$getFileFeatures_u24lambda_u240.add(Fields.INSTANCE.getDIRECTORY_DEPTH_DATA_KEY().with((Object)it));
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventPair<?>> getFileTypeStats(VirtualFile file, long currentTime, Map<String, FileTypeUsageSummary> fileTypeStats) {
        Iterable iterable = fileTypeStats.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            FileTypeUsageSummary fileTypeUsageSummary = (FileTypeUsageSummary)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.usageCount;
            n = n2 + n3;
        }
        int totalUsage = n;
        FileTypeUsageSummary stats = fileTypeStats.get(file.getFileType().getName());
        if (stats == null) {
            return CollectionsKt.emptyList();
        }
        long timeSinceLastUsage = currentTime - stats.lastUsed;
        double usageRatio = SearchEverywhereElementFeaturesProvider.Companion.roundDouble$intellij_searchEverywhereMl_ranking_core((double)stats.usageCount / (double)totalUsage);
        Object[] objectArray = ((Iterable)fileTypeStats.entrySet()).iterator();
        if (!objectArray.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry it = (Map.Entry)objectArray.next();
        boolean bl = false;
        int n4 = ((FileTypeUsageSummary)it.getValue()).usageCount;
        while (objectArray.hasNext()) {
            Map.Entry it22 = (Map.Entry)objectArray.next();
            $i$a$-minOf-SearchEverywhereClassOrFileFeaturesProvider$getFileTypeStats$min$1 = false;
            int it22 = ((FileTypeUsageSummary)it22.getValue()).usageCount;
            if (n4 <= it22) continue;
            n4 = it22;
        }
        int min = n4;
        Iterator iterator = ((Iterable)fileTypeStats.entrySet()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry it2 = (Map.Entry)iterator.next();
        boolean bl2 = false;
        int n5 = ((FileTypeUsageSummary)it2.getValue()).usageCount;
        while (iterator.hasNext()) {
            Map.Entry it3 = (Map.Entry)iterator.next();
            $i$a$-maxOf-SearchEverywhereClassOrFileFeaturesProvider$getFileTypeStats$max$1 = false;
            int n6 = ((FileTypeUsageSummary)it3.getValue()).usageCount;
            if (n5 >= n6) continue;
            n5 = n6;
        }
        int max = n5;
        objectArray = new EventPair[]{Fields.INSTANCE.getFILETYPE_USAGE_RATIO_DATA_KEY().with((Object)usageRatio), Fields.INSTANCE.getFILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY().with((Object)SearchEverywhereElementFeaturesProvider.Companion.roundDouble$intellij_searchEverywhereMl_ranking_core((double)stats.usageCount / (double)max)), Fields.INSTANCE.getFILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY().with((Object)SearchEverywhereElementFeaturesProvider.Companion.roundDouble$intellij_searchEverywhereMl_ranking_core((double)stats.usageCount / (double)min)), Fields.INSTANCE.getTIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY().with((Object)timeSinceLastUsage), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_MINUTE_DATA_KEY().with((Object)(timeSinceLastUsage <= 60000L ? 1 : 0)), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_HOUR_DATA_KEY().with((Object)(timeSinceLastUsage <= 3600000L ? 1 : 0)), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_DAY_DATA_KEY().with((Object)(timeSinceLastUsage <= 86400000L ? 1 : 0)), Fields.INSTANCE.getFILETYPE_USED_IN_LAST_MONTH_DATA_KEY().with((Object)(timeSinceLastUsage <= 2419200000L ? 1 : 0))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Boolean isSameModuleAsOpenedFile(VirtualFile file, Project project, VirtualFile openedFile) {
        if (openedFile == null) {
            return null;
        }
        Pair pair = (Pair)ReadAction.compute(() -> SearchEverywhereClassOrFileFeaturesProvider.isSameModuleAsOpenedFile$lambda$0(project, openedFile, file));
        Module openedFileModule = (Module)pair.component1();
        Module itemModule = (Module)pair.component2();
        if (openedFileModule == null || itemModule == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)openedFileModule, (Object)itemModule);
    }

    private final Integer calculateRootDistance(VirtualFile file, Project project) {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile contentRoot = virtualFile;
        Object object = file.getParent();
        if (object == null || (object = VirtualFileUtil.toNioPathOrNull((VirtualFile)object)) == null) {
            return null;
        }
        Object fileDirectoryPath = object;
        Path path = VirtualFileUtil.toNioPathOrNull((VirtualFile)contentRoot);
        if (path == null) {
            return null;
        }
        Path contentRootPath = path;
        if (!fileDirectoryPath.startsWith(contentRootPath)) {
            return null;
        }
        Path relativePath = contentRootPath.relativize((Path)fileDirectoryPath);
        if (((CharSequence)((Object)relativePath).toString()).length() == 0) {
            return 0;
        }
        return relativePath.getNameCount();
    }

    private final Boolean isSameFileTypeAsOpenedFile(VirtualFile file, VirtualFile openedFile) {
        VirtualFile virtualFile = openedFile;
        if (virtualFile == null || (virtualFile = virtualFile.getFileType()) == null) {
            return null;
        }
        VirtualFile openedFileType = virtualFile;
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)openedFileType);
    }

    private final List<EventPair<?>> getFileLocationStats(VirtualFile file, Project project) {
        Object object = ReadAction.compute(() -> SearchEverywhereClassOrFileFeaturesProvider.getFileLocationStats$lambda$0(project, file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    private final int getRecentFilesIndex(VirtualFile virtualFile, Project project) {
        EditorHistoryManager historyManager = EditorHistoryManager.Companion.getInstance(project);
        List recentFilesList = historyManager.getFileList();
        int fileIndex = recentFilesList.indexOf(virtualFile);
        if (fileIndex == -1) {
            return fileIndex;
        }
        return recentFilesList.size() - fileIndex;
    }

    private final List<EventPair<?>> getModificationTimeStats(VirtualFile virtualFile, long currentTime) {
        long timeSinceLastMod = currentTime - virtualFile.getTimeStamp();
        Object[] objectArray = new EventPair[]{Fields.INSTANCE.getTIME_SINCE_LAST_MODIFICATION_DATA_KEY().with((Object)timeSinceLastMod), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY().with((Object)(timeSinceLastMod <= 60000L ? 1 : 0)), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_HOUR_DATA_KEY().with((Object)(timeSinceLastMod <= 3600000L ? 1 : 0)), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_DAY_DATA_KEY().with((Object)(timeSinceLastMod <= 86400000L ? 1 : 0)), Fields.INSTANCE.getWAS_MODIFIED_IN_LAST_MONTH_DATA_KEY().with((Object)(timeSinceLastMod <= 2419200000L ? 1 : 0))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final double getPredictionScore(VirtualFile virtualFile, Project project) {
        FileHistoryManagerWrapper historyManagerWrapper = FileHistoryManagerWrapper.Companion.getInstance(project);
        double probability = historyManagerWrapper.calcNextFileProbability(virtualFile);
        return SearchEverywhereElementFeaturesProvider.Companion.roundDouble$intellij_searchEverywhereMl_ranking_core(probability);
    }

    private final boolean isOpened(VirtualFile virtualFile, Project project) {
        Object[] objectArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenFiles(...)");
        Object[] openedFiles = objectArray;
        return ArraysKt.contains((Object[])openedFiles, (Object)virtualFile);
    }

    private final boolean allInitialLettersMatch(Object element, String query) {
        char it;
        char element$iv$iv;
        int index$iv$iv;
        CharSequence $this$filterTo$iv$iv;
        String $this$filter$iv;
        String string = this.getElementName(element);
        if (string == null) {
            return false;
        }
        String name = string;
        Object object = new String[]{"_"};
        object = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)name, (String[])object, (boolean)false, (int)0, (int)6, null), null, null, null, (int)0, null, SearchEverywhereClassOrFileFeaturesProvider::allInitialLettersMatch$lambda$0, (int)31, null);
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isUpperCase(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String transformedElementName = ((StringBuilder)destination$iv$iv).toString();
        $this$filter$iv = query;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new StringBuilder();
        $i$f$filterTo = false;
        n = $this$filterTo$iv$iv.length();
        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isUpperCase(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return Intrinsics.areEqual((Object)((StringBuilder)destination$iv$iv).toString(), (Object)transformedElementName);
    }

    private final String getElementName(Object element) {
        PsiElement psiElement = SearchEverywherePsiElementFeaturesProviderUtils.INSTANCE.getPsiElementOrNull(element);
        if (psiElement != null) {
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            PsiElement psiElement3 = psiElement2;
            return psiElement3 instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiElement2).getVirtualFile().getNameWithoutExtension() : (psiElement3 instanceof PsiNamedElement ? ((PsiNamedElement)psiElement2).getName() : null);
        }
        if (element instanceof NavigationItem) {
            return ((NavigationItem)element).getName();
        }
        return null;
    }

    private static final Project getElementFeatures$lambda$0$0$0(PsiElement $item) {
        PsiElement psiElement;
        PsiElement it = psiElement = $item;
        boolean bl = false;
        Object object = it.isValid() ? psiElement : null;
        return object != null ? object.getProject() : null;
    }

    private static final List isAccessibleFromModule$lambda$0$0(PsiElement $element, VirtualFile $it) {
        if (!$element.isValid()) {
            return CollectionsKt.listOf((Object)SearchEverywherePsiElementFeaturesProvider.Fields.getIS_INVALID_DATA_KEY().with((Object)true));
        }
        PsiFile psiFile = $element.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile elementFile = psiFile;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)$element.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        Module openedFileModule = fileIndex.getModuleForFile($it);
        Module elementModule = fileIndex.getModuleForFile((VirtualFile)elementFile);
        if (openedFileModule == null || elementModule == null) {
            return CollectionsKt.emptyList();
        }
        BooleanEventField booleanEventField = Fields.INSTANCE.getIS_ACCESSIBLE_FROM_MODULE();
        String[] stringArray = ModuleRootManager.getInstance((Module)openedFileModule).getDependencyModuleNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getDependencyModuleNames(...)");
        return CollectionsKt.listOf((Object)booleanEventField.with((Object)ArraysKt.contains((Object[])stringArray, (Object)elementModule.getName())));
    }

    private static final VirtualFile getContainingFile$lambda$0(PsiElement $item) {
        VirtualFile virtualFile;
        try {
            PsiFile psiFile = $item.getContainingFile();
            virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        }
        catch (PsiInvalidElementAccessException ex) {
            virtualFile = null;
        }
        return virtualFile;
    }

    private static final Pair isSameModuleAsOpenedFile$lambda$0(Project $project, VirtualFile $openedFile, VirtualFile $file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)$project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        return new Pair((Object)fileIndex.getModuleForFile($openedFile), (Object)fileIndex.getModuleForFile($file));
    }

    private static final List getFileLocationStats$lambda$0(Project $project, VirtualFile $file) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        Object[] objectArray = new EventPair[]{Fields.INSTANCE.getIS_IN_SOURCE_DATA_KEY().with((Object)fileIndex.isInSource($file)), Fields.INSTANCE.getIS_IN_TEST_SOURCES_DATA_KEY().with((Object)fileIndex.isInTestSourceContent($file)), Fields.INSTANCE.getIS_IN_LIBRARY_DATA_KEY().with((Object)fileIndex.isInLibrary($file)), Fields.INSTANCE.getIS_EXCLUDED_DATA_KEY().with((Object)fileIndex.isExcluded($file))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence allInitialLettersMatch$lambda$0(String substring) {
        String string;
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        String string2 = substring;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007R\u0011\u0010,\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\rR\u0011\u0010.\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001bR\u0011\u00100\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0007R\u0011\u00102\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010#R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0007R\u0011\u00106\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0007R\u0011\u00108\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0007R\u0011\u0010:\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0007R\u0011\u0010<\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0007\u00a8\u0006>"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereClassOrFileFeaturesProvider$Fields;", "", "<init>", "()V", "IS_ACCESSIBLE_FROM_MODULE", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getIS_ACCESSIBLE_FROM_MODULE", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_SAME_MODULE_DATA_KEY", "getIS_SAME_MODULE_DATA_KEY", "DIRECTORY_DEPTH_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getDIRECTORY_DEPTH_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "IS_SAME_FILETYPE_AS_OPENED_FILE_DATA_KEY", "getIS_SAME_FILETYPE_AS_OPENED_FILE_DATA_KEY", "IS_IN_SOURCE_DATA_KEY", "getIS_IN_SOURCE_DATA_KEY", "IS_IN_TEST_SOURCES_DATA_KEY", "getIS_IN_TEST_SOURCES_DATA_KEY", "IS_IN_LIBRARY_DATA_KEY", "getIS_IN_LIBRARY_DATA_KEY", "IS_EXCLUDED_DATA_KEY", "getIS_EXCLUDED_DATA_KEY", "FILETYPE_USAGE_RATIO_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "getFILETYPE_USAGE_RATIO_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "FILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY", "getFILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY", "FILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY", "getFILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY", "TIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "getTIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "FILETYPE_USED_IN_LAST_MINUTE_DATA_KEY", "getFILETYPE_USED_IN_LAST_MINUTE_DATA_KEY", "FILETYPE_USED_IN_LAST_HOUR_DATA_KEY", "getFILETYPE_USED_IN_LAST_HOUR_DATA_KEY", "FILETYPE_USED_IN_LAST_DAY_DATA_KEY", "getFILETYPE_USED_IN_LAST_DAY_DATA_KEY", "FILETYPE_USED_IN_LAST_MONTH_DATA_KEY", "getFILETYPE_USED_IN_LAST_MONTH_DATA_KEY", "RECENT_INDEX_DATA_KEY", "getRECENT_INDEX_DATA_KEY", "PREDICTION_SCORE_DATA_KEY", "getPREDICTION_SCORE_DATA_KEY", "IS_OPENED_DATA_KEY", "getIS_OPENED_DATA_KEY", "TIME_SINCE_LAST_MODIFICATION_DATA_KEY", "getTIME_SINCE_LAST_MODIFICATION_DATA_KEY", "WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY", "getWAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY", "WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY", "getWAS_MODIFIED_IN_LAST_HOUR_DATA_KEY", "WAS_MODIFIED_IN_LAST_DAY_DATA_KEY", "getWAS_MODIFIED_IN_LAST_DAY_DATA_KEY", "WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY", "getWAS_MODIFIED_IN_LAST_MONTH_DATA_KEY", "ALL_INITIAL_LETTERS_MATCH_DATA_KEY", "getALL_INITIAL_LETTERS_MATCH_DATA_KEY", "intellij.searchEverywhereMl.ranking.core"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        private static final BooleanEventField IS_ACCESSIBLE_FROM_MODULE = EventFields.Boolean((String)"isAccessibleFromModule");
        @NotNull
        private static final BooleanEventField IS_SAME_MODULE_DATA_KEY = EventFields.Boolean((String)"isSameModule");
        @NotNull
        private static final IntEventField DIRECTORY_DEPTH_DATA_KEY = EventFields.Int((String)"directoryDepth");
        @NotNull
        private static final BooleanEventField IS_SAME_FILETYPE_AS_OPENED_FILE_DATA_KEY = EventFields.Boolean((String)"isSameFileTypeAsOpenedFile");
        @NotNull
        private static final BooleanEventField IS_IN_SOURCE_DATA_KEY = EventFields.Boolean((String)"isInSource");
        @NotNull
        private static final BooleanEventField IS_IN_TEST_SOURCES_DATA_KEY = EventFields.Boolean((String)"isInTestSources");
        @NotNull
        private static final BooleanEventField IS_IN_LIBRARY_DATA_KEY = EventFields.Boolean((String)"isFromLibrary");
        @NotNull
        private static final BooleanEventField IS_EXCLUDED_DATA_KEY = EventFields.Boolean((String)"isInExcluded");
        @NotNull
        private static final DoubleEventField FILETYPE_USAGE_RATIO_DATA_KEY = EventFields.Double((String)"fileTypeUsageRatio");
        @NotNull
        private static final DoubleEventField FILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY = EventFields.Double((String)"fileTypeUsageRatioToMax");
        @NotNull
        private static final DoubleEventField FILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY = EventFields.Double((String)"fileTypeUsageRatioToMin");
        @NotNull
        private static final LongEventField TIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY = EventFields.Long$default((String)"timeSinceLastFileTypeUsage", null, (int)2, null);
        @NotNull
        private static final BooleanEventField FILETYPE_USED_IN_LAST_MINUTE_DATA_KEY = EventFields.Boolean((String)"fileTypeUsedInLastMinute");
        @NotNull
        private static final BooleanEventField FILETYPE_USED_IN_LAST_HOUR_DATA_KEY = EventFields.Boolean((String)"fileTypeUsedInLastHour");
        @NotNull
        private static final BooleanEventField FILETYPE_USED_IN_LAST_DAY_DATA_KEY = EventFields.Boolean((String)"fileTypeUsedInLastDay");
        @NotNull
        private static final BooleanEventField FILETYPE_USED_IN_LAST_MONTH_DATA_KEY = EventFields.Boolean((String)"fileTypeUsedInLastMonth");
        @NotNull
        private static final IntEventField RECENT_INDEX_DATA_KEY = EventFields.Int((String)"recentFilesIndex");
        @NotNull
        private static final DoubleEventField PREDICTION_SCORE_DATA_KEY = EventFields.Double((String)"predictionScore");
        @NotNull
        private static final BooleanEventField IS_OPENED_DATA_KEY = EventFields.Boolean((String)"isOpened");
        @NotNull
        private static final LongEventField TIME_SINCE_LAST_MODIFICATION_DATA_KEY = EventFields.Long$default((String)"timeSinceLastModification", null, (int)2, null);
        @NotNull
        private static final BooleanEventField WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastMinute");
        @NotNull
        private static final BooleanEventField WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastHour");
        @NotNull
        private static final BooleanEventField WAS_MODIFIED_IN_LAST_DAY_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastDay");
        @NotNull
        private static final BooleanEventField WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY = EventFields.Boolean((String)"wasModifiedInLastMonth");
        @NotNull
        private static final BooleanEventField ALL_INITIAL_LETTERS_MATCH_DATA_KEY = EventFields.Boolean((String)"allInitialLettersMatch");

        private Fields() {
        }

        @NotNull
        public final BooleanEventField getIS_ACCESSIBLE_FROM_MODULE() {
            return IS_ACCESSIBLE_FROM_MODULE;
        }

        @NotNull
        public final BooleanEventField getIS_SAME_MODULE_DATA_KEY() {
            return IS_SAME_MODULE_DATA_KEY;
        }

        @NotNull
        public final IntEventField getDIRECTORY_DEPTH_DATA_KEY() {
            return DIRECTORY_DEPTH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_SAME_FILETYPE_AS_OPENED_FILE_DATA_KEY() {
            return IS_SAME_FILETYPE_AS_OPENED_FILE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_IN_SOURCE_DATA_KEY() {
            return IS_IN_SOURCE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_IN_TEST_SOURCES_DATA_KEY() {
            return IS_IN_TEST_SOURCES_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_IN_LIBRARY_DATA_KEY() {
            return IS_IN_LIBRARY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXCLUDED_DATA_KEY() {
            return IS_EXCLUDED_DATA_KEY;
        }

        @NotNull
        public final DoubleEventField getFILETYPE_USAGE_RATIO_DATA_KEY() {
            return FILETYPE_USAGE_RATIO_DATA_KEY;
        }

        @NotNull
        public final DoubleEventField getFILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY() {
            return FILETYPE_USAGE_RATIO_TO_MAX_DATA_KEY;
        }

        @NotNull
        public final DoubleEventField getFILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY() {
            return FILETYPE_USAGE_RATIO_TO_MIN_DATA_KEY;
        }

        @NotNull
        public final LongEventField getTIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY() {
            return TIME_SINCE_LAST_FILETYPE_USAGE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_USED_IN_LAST_MINUTE_DATA_KEY() {
            return FILETYPE_USED_IN_LAST_MINUTE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_USED_IN_LAST_HOUR_DATA_KEY() {
            return FILETYPE_USED_IN_LAST_HOUR_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_USED_IN_LAST_DAY_DATA_KEY() {
            return FILETYPE_USED_IN_LAST_DAY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_USED_IN_LAST_MONTH_DATA_KEY() {
            return FILETYPE_USED_IN_LAST_MONTH_DATA_KEY;
        }

        @NotNull
        public final IntEventField getRECENT_INDEX_DATA_KEY() {
            return RECENT_INDEX_DATA_KEY;
        }

        @NotNull
        public final DoubleEventField getPREDICTION_SCORE_DATA_KEY() {
            return PREDICTION_SCORE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_OPENED_DATA_KEY() {
            return IS_OPENED_DATA_KEY;
        }

        @NotNull
        public final LongEventField getTIME_SINCE_LAST_MODIFICATION_DATA_KEY() {
            return TIME_SINCE_LAST_MODIFICATION_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY() {
            return WAS_MODIFIED_IN_LAST_MINUTE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_HOUR_DATA_KEY() {
            return WAS_MODIFIED_IN_LAST_HOUR_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_DAY_DATA_KEY() {
            return WAS_MODIFIED_IN_LAST_DAY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getWAS_MODIFIED_IN_LAST_MONTH_DATA_KEY() {
            return WAS_MODIFIED_IN_LAST_MONTH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getALL_INITIAL_LETTERS_MATCH_DATA_KEY() {
            return ALL_INITIAL_LETTERS_MATCH_DATA_KEY;
        }
    }
}

